/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class UndocumentedPermissionsRecipe
extends Recipe {
    public String getDisplayName() {
        return "Document permissions usage";
    }

    public String getDescription() {
        return "Add documentation comments for permissions blocks in GitHub Actions workflows. Documenting permissions helps reviewers understand why specific permissions are needed and ensures security-conscious development practices. Based on [zizmor's undocumented-permissions audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/undocumented_permissions.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new UndocumentedPermissionsVisitor());
    }

    @Generated
    public UndocumentedPermissionsRecipe() {
    }

    @Generated
    public String toString() {
        return "UndocumentedPermissionsRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UndocumentedPermissionsRecipe)) {
            return false;
        }
        UndocumentedPermissionsRecipe other = (UndocumentedPermissionsRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UndocumentedPermissionsRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class UndocumentedPermissionsVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private UndocumentedPermissionsVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isPermissionsEntry(mappingEntry) && !this.hasDocumentationComment(mappingEntry)) {
                String context = this.getPermissionsContext();
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)mappingEntry, (String)("Permissions block lacks documentation comment. Consider adding a comment explaining why these permissions are needed" + (context != null ? " for " + context : "") + "."));
            }
            return mappingEntry;
        }

        private boolean isPermissionsEntry(Yaml.Mapping.Entry entry) {
            return entry.getKey() instanceof Yaml.Scalar && "permissions".equals(((Yaml.Scalar)entry.getKey()).getValue());
        }

        private boolean hasDocumentationComment(Yaml.Mapping.Entry entry) {
            return false;
        }

        private String getPermissionsContext() {
            for (Cursor cursor = this.getCursor(); cursor != null; cursor = cursor.getParent()) {
                Yaml.Mapping.Entry ggEntry;
                Cursor grandparent;
                Yaml.Mapping.Entry parentEntry;
                if (cursor.getValue() instanceof Yaml.Mapping) {
                    Yaml.Mapping mapping = (Yaml.Mapping)cursor.getValue();
                    for (Yaml.Mapping.Entry entry : mapping.getEntries()) {
                        String key;
                        if (!(entry.getKey() instanceof Yaml.Scalar) || !"jobs".equals(key = ((Yaml.Scalar)entry.getKey()).getValue())) continue;
                        return "workflow";
                    }
                }
                if (cursor.getParent() == null || !(cursor.getParent().getValue() instanceof Yaml.Mapping.Entry) || !((parentEntry = (Yaml.Mapping.Entry)cursor.getParent().getValue()).getKey() instanceof Yaml.Scalar) || (grandparent = cursor.getParent().getParent()) == null || grandparent.getParent() == null || !(grandparent.getParent().getValue() instanceof Yaml.Mapping.Entry) || !((ggEntry = (Yaml.Mapping.Entry)grandparent.getParent().getValue()).getKey() instanceof Yaml.Scalar) || !"jobs".equals(((Yaml.Scalar)ggEntry.getKey()).getValue())) continue;
                return "this job";
            }
            return null;
        }
    }
}

