/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class RefVersionMismatchRecipe
extends Recipe {
    private static final Pattern SHA_PATTERN = Pattern.compile("^[a-f0-9]{40}$");
    private static final Pattern[] VERSION_COMMENT_PATTERNS = new Pattern[]{Pattern.compile("#\\s*tag\\s*=\\s*(v?\\d+(?:\\.\\d+)*(?:\\.\\d+)?)"), Pattern.compile("#\\s*(v?\\d+(?:\\.\\d+)*(?:\\.\\d+)?)\\s*$"), Pattern.compile("#\\s*(?:version|ver)\\s*[:=]\\s*(v?\\d+(?:\\.\\d+)*(?:\\.\\d+)?)"), Pattern.compile("#\\s*tag\\s*=\\s*([vV]?\\d+)")};

    public String getDisplayName() {
        return "Find commit SHAs with potentially mismatched version comments";
    }

    public String getDescription() {
        return "Find GitHub Actions that are pinned to commit SHAs but have version comments that may not match the actual pinned version. This can lead to confusion about which version is actually being used and potential security issues if the comment misleads developers about the pinned version. Based on [zizmor's `ref-version-mismatch` audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/ref_version_mismatch.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new RefVersionMismatchVisitor());
    }

    @Generated
    public RefVersionMismatchRecipe() {
    }

    @Generated
    public String toString() {
        return "RefVersionMismatchRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefVersionMismatchRecipe)) {
            return false;
        }
        RefVersionMismatchRecipe other = (RefVersionMismatchRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RefVersionMismatchRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class RefVersionMismatchVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private RefVersionMismatchVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isUsesEntry(mappingEntry)) {
                return this.checkUsesEntry(mappingEntry);
            }
            return mappingEntry;
        }

        private boolean isUsesEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return false;
            }
            Yaml.Scalar key = (Yaml.Scalar)entry.getKey();
            return "uses".equals(key.getValue());
        }

        private Yaml.Mapping.Entry checkUsesEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getValue() instanceof Yaml.Scalar)) {
                return entry;
            }
            String usesValue = ((Yaml.Scalar)entry.getValue()).getValue();
            if (usesValue.startsWith("./") || usesValue.startsWith("docker://")) {
                return entry;
            }
            String[] parts = usesValue.split("@", 2);
            if (parts.length < 2) {
                return entry;
            }
            String version = parts[1];
            if (!SHA_PATTERN.matcher(version).matches()) {
                return entry;
            }
            if (this.hasVersionComment(entry)) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Action is pinned to a commit SHA but has a version comment that may not match. Verify the comment reflects the actual pinned version.");
            }
            return entry;
        }

        private boolean hasVersionComment(Yaml.Mapping.Entry entry) {
            String prefix = entry.getPrefix();
            if (prefix != null && this.containsVersionComment(prefix)) {
                return true;
            }
            return this.checkPrecedingComments(entry);
        }

        private boolean containsVersionComment(String text) {
            for (Pattern pattern : VERSION_COMMENT_PATTERNS) {
                if (!pattern.matcher(text).find()) continue;
                return true;
            }
            return false;
        }

        private boolean checkPrecedingComments(Yaml.Mapping.Entry entry) {
            for (Cursor current = this.getCursor(); current != null; current = current.getParent()) {
                Yaml.Sequence.Entry seqEntry;
                String seqPrefix;
                Object value = current.getValue();
                if (!(value instanceof Yaml.Sequence.Entry) || (seqPrefix = (seqEntry = (Yaml.Sequence.Entry)value).getPrefix()) == null || !this.containsVersionComment(seqPrefix)) continue;
                return true;
            }
            return false;
        }
    }
}

