/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class SecretsInheritRecipe
extends Recipe {
    public String getDisplayName() {
        return "Find unconditional secrets inheritance";
    }

    public String getDescription() {
        return "Detects when reusable workflows unconditionally inherit all parent secrets via `secrets: inherit`. This practice can lead to over-privileged workflows and potential secret exposure to called workflows that may not need access to all secrets. Consider explicitly passing only required secrets. Based on [zizmor's secrets-inherit audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/secrets_inherit.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SecretsInheritVisitor();
    }

    @Generated
    public SecretsInheritRecipe() {
    }

    @Generated
    public String toString() {
        return "SecretsInheritRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretsInheritRecipe)) {
            return false;
        }
        SecretsInheritRecipe other = (SecretsInheritRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SecretsInheritRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class SecretsInheritVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private SecretsInheritVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isSecretsInheritEntry(mappingEntry)) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)mappingEntry, (String)"This reusable workflow unconditionally inherits all parent secrets. Consider explicitly passing only the required secrets to follow the principle of least privilege and reduce the risk of secret exposure to called workflows.");
            }
            return mappingEntry;
        }

        private boolean isSecretsInheritEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return false;
            }
            String key = ((Yaml.Scalar)entry.getKey()).getValue();
            if (!"secrets".equals(key)) {
                return false;
            }
            if (!(entry.getValue() instanceof Yaml.Scalar)) {
                return false;
            }
            String value = ((Yaml.Scalar)entry.getValue()).getValue();
            return "inherit".equals(value);
        }
    }
}

