/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.yaml.MergeYaml;

public class AddCronTrigger
extends Recipe {
    @Option(displayName="Cron expression", description="Using the [POSIX cron syntax](https://pubs.opengroup.org/onlinepubs/9699919799/utilities/crontab.html#tag_20_25_07).", example="0 18 * * *")
    private final String cron;

    public AddCronTrigger(String cron) {
        this.cron = cron;
        this.doNext((Recipe)new MergeYaml("/on", "schedule:\n  - cron: \"0 18 * * *\"", Boolean.valueOf(true), ".github/workflows/*.yml"));
    }

    public String getDisplayName() {
        return "Add cron workflow trigger";
    }

    public String getDescription() {
        return "The `schedule` [event](https://docs.github.com/en/actions/reference/events-that-trigger-workflows#scheduled-events) allows you to trigger a workflow at a scheduled time.";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddCronTrigger)) {
            return false;
        }
        AddCronTrigger other = (AddCronTrigger)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$cron = this.getCron();
        String other$cron = other.getCron();
        return !(this$cron == null ? other$cron != null : !this$cron.equals(other$cron));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddCronTrigger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cron = this.getCron();
        result = result * 59 + ($cron == null ? 43 : $cron.hashCode());
        return result;
    }

    public String getCron() {
        return this.cron;
    }
}

