/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient5;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.apache.httpclient5.NonRepeatableByteArrayArgumentMatcher;
import org.openrewrite.apache.httpclient5.RepeatableByteArrayArgumentMatcher;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;

public final class OutputBufferWriteAddOffsetAndLengthArguments
extends Recipe {
    private static final String WRITE_PATTERN = "org.apache.hc.core5.http.nio.support.classic.SharedOutputBuffer write(byte[])";
    private static final MethodMatcher WRITE_MATCHER = new MethodMatcher("org.apache.hc.core5.http.nio.support.classic.SharedOutputBuffer write(byte[])");

    public String getDisplayName() {
        return "Adds offset and length arguments to the write method of SharedOutputBuffer";
    }

    public String getDescription() {
        return "In Apache Http Client 5.x migration, the shortened form of the `write(byte[])` has been removed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(WRITE_PATTERN), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (WRITE_MATCHER.matches((MethodCall)m)) {
                    Expression firstArg = (Expression)m.getArguments().get(0);
                    JavaTemplate after = JavaTemplate.builder((String)"#{any(org.apache.hc.core5.http.nio.support.classic.SharedOutputBuffer)}.write(#{any(byte[])}, 0, #{any(byte[])}.length)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpcore5"})).build();
                    if (new RepeatableByteArrayArgumentMatcher().matches(firstArg)) {
                        return (J.MethodInvocation)after.apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{Objects.requireNonNull(m.getSelect()), firstArg, firstArg});
                    }
                    if (new NonRepeatableByteArrayArgumentMatcher().matches(firstArg)) {
                        return (J.MethodInvocation)after.apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{Objects.requireNonNull(m.getSelect()), firstArg, firstArg}).withComments(ListUtils.concat((List)m.getComments(), (Object)new TextComment(true, " TODO: Please check that repeated obtaining of byte[] is safe here ", m.getPrefix().getWhitespace(), Markers.EMPTY)));
                    }
                }
                return m;
            }
        });
    }

    @Generated
    public OutputBufferWriteAddOffsetAndLengthArguments() {
    }

    @Generated
    public String toString() {
        return "OutputBufferWriteAddOffsetAndLengthArguments()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputBufferWriteAddOffsetAndLengthArguments)) {
            return false;
        }
        OutputBufferWriteAddOffsetAndLengthArguments other = (OutputBufferWriteAddOffsetAndLengthArguments)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputBufferWriteAddOffsetAndLengthArguments;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

