/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import lombok.Generated;
import org.openrewrite.Incubating;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.java.tree.J;

@Incubating(since="7.24.0")
public class FlowGraph {
    private final Factory factory;
    private final DataFlowNode node;
    private Map<J, FlowGraph> edges = Collections.emptyMap();

    public List<FlowGraph> getEdges() {
        if (this.edges.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<FlowGraph>(this.edges.values()));
    }

    @CheckReturnValue
    public FlowGraph addEdge(DataFlowNode node) {
        if (this.edges.isEmpty()) {
            this.edges = new IdentityHashMap<J, FlowGraph>(1);
        }
        return this.edges.computeIfAbsent((J)node.getCursor().getValue(), __ -> this.factory.create(node));
    }

    public FlowGraph addEdge(FlowGraph edge) {
        FlowGraph previous;
        if (this.edges.isEmpty()) {
            this.edges = new IdentityHashMap<J, FlowGraph>(1);
        }
        if ((previous = this.edges.put((J)edge.getNode().getCursor().getValue(), edge)) != null && !previous.equals(edge)) {
            throw new IllegalStateException("Edge already exists!");
        }
        return edge;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{edges=" + this.edges.size() + ", cursor=" + this.node.getCursor() + '}';
    }

    public void removeEdge(FlowGraph edge) {
        this.edges.remove(edge.getNode().getCursor().getValue(), edge);
    }

    @Generated
    public FlowGraph(Factory factory, DataFlowNode node) {
        this.factory = factory;
        this.node = node;
    }

    @Generated
    public DataFlowNode getNode() {
        return this.node;
    }

    public static interface Factory {
        public FlowGraph create(DataFlowNode var1);

        public static Factory defaultFactory() {
            return new Factory(){

                @Override
                public FlowGraph create(DataFlowNode node) {
                    return new FlowGraph(this, node);
                }
            };
        }

        public static Factory throwing() {
            return node -> {
                throw new UnsupportedOperationException();
            };
        }
    }
}

