/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.controlflow;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.analysis.controlflow.ControlFlowNode;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

final class ControlFlowIllegalStateException
extends IllegalStateException {
    ControlFlowIllegalStateException(Message.MessageBuilder message) {
        super(message.build().createMessage());
    }

    ControlFlowIllegalStateException(String message, ControlFlowNode thisNode) {
        this(ControlFlowIllegalStateException.exceptionMessageBuilder(message).thisNode(thisNode));
    }

    static Message.MessageBuilder exceptionMessageBuilder(String message) {
        return new Message.MessageBuilder(message);
    }

    static final class Message {
        private final String message;
        private final LinkedHashMap<String, ControlFlowNode> nodes;
        private final Set<ControlFlowNode> predecessors;
        private final Cursor cursor;

        private String createMessage() {
            StringBuilder sb = new StringBuilder(this.message);
            if (this.cursor != null) {
                sb.append("\n\tAST: ").append(this.cursor.getValue());
                sb.append("\n\tCursor: ").append(this.cursor);
            }
            this.nodes.forEach((key, node) -> sb.append("\n\t").append((String)key).append(": ").append(node.getClass().getSimpleName()).append(" ").append(node.toDescriptiveString()));
            if (!this.predecessors.isEmpty()) {
                sb.append("\n\tPredecessors: ").append(this.predecessors.stream().map(ControlFlowNode::toDescriptiveString).reduce("\n\t\t", (a, b) -> a + "\n\t\t" + b));
            }
            return sb.toString();
        }

        @Generated
        public Message(String message, LinkedHashMap<String, ControlFlowNode> nodes, Set<ControlFlowNode> predecessors, Cursor cursor) {
            this.message = message;
            this.nodes = nodes;
            this.predecessors = predecessors;
            this.cursor = cursor;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public LinkedHashMap<String, ControlFlowNode> getNodes() {
            return this.nodes;
        }

        @Generated
        public Set<ControlFlowNode> getPredecessors() {
            return this.predecessors;
        }

        @Generated
        public Cursor getCursor() {
            return this.cursor;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            LinkedHashMap<String, ControlFlowNode> this$nodes = this.getNodes();
            LinkedHashMap<String, ControlFlowNode> other$nodes = other.getNodes();
            if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
                return false;
            }
            Set<ControlFlowNode> this$predecessors = this.getPredecessors();
            Set<ControlFlowNode> other$predecessors = other.getPredecessors();
            if (this$predecessors == null ? other$predecessors != null : !((Object)this$predecessors).equals(other$predecessors)) {
                return false;
            }
            Cursor this$cursor = this.getCursor();
            Cursor other$cursor = other.getCursor();
            return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            LinkedHashMap<String, ControlFlowNode> $nodes = this.getNodes();
            result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
            Set<ControlFlowNode> $predecessors = this.getPredecessors();
            result = result * 59 + ($predecessors == null ? 43 : ((Object)$predecessors).hashCode());
            Cursor $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ControlFlowIllegalStateException.Message(message=" + this.getMessage() + ", nodes=" + this.getNodes() + ", predecessors=" + this.getPredecessors() + ", cursor=" + this.getCursor() + ")";
        }

        static final class MessageBuilder {
            private final String message;
            private final LinkedHashMap<String, ControlFlowNode> nodes = new LinkedHashMap();
            private final Set<ControlFlowNode> predecessors = new LinkedHashSet<ControlFlowNode>();
            private Cursor cursor;

            private MessageBuilder(String message) {
                this.message = message;
            }

            MessageBuilder thisNode(ControlFlowNode node) {
                return this.addNode("This", node);
            }

            MessageBuilder current(ControlFlowNode node) {
                return this.addNode("Current", node);
            }

            MessageBuilder otherNode(ControlFlowNode node) {
                return this.addNode("Other", node);
            }

            MessageBuilder addPredecessors(ControlFlowNode node) {
                this.predecessors.addAll(node.predecessors);
                return this;
            }

            MessageBuilder addNode(String name, ControlFlowNode node) {
                this.nodes.put(name, node);
                return this;
            }

            MessageBuilder addCursor(Cursor cursor) {
                this.cursor = cursor;
                return this;
            }

            Message build() {
                return new Message(this.message, this.nodes, this.predecessors, this.cursor);
            }
        }
    }
}

