/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.InvocationMatcher;
import org.openrewrite.analysis.controlflow.Guard;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.dataflow.Dataflow;
import org.openrewrite.analysis.dataflow.LocalFlowSpec;
import org.openrewrite.analysis.trait.expr.BinaryExpr;
import org.openrewrite.analysis.trait.expr.Literal;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class UriCreatedWithHttpScheme
extends Recipe {
    private static final MethodMatcher URI_CREATE_METHOD_MATCHER = new MethodMatcher("java.net.URI create(..)");
    private static final InvocationMatcher URI_CREATE = InvocationMatcher.fromMethodMatcher(URI_CREATE_METHOD_MATCHER);
    private static final MethodMatcher STRING_REPLACE = new MethodMatcher("java.lang.String replace(..)");
    private static final LocalFlowSpec<J.Literal, Expression> INSECURE_URI_CREATE = new LocalFlowSpec<J.Literal, Expression>(){

        @Override
        public boolean isSource(DataFlowNode srcNode) {
            return srcNode.asExpr(Literal.class).flatMap(Literal::getValue).map(v -> v.toString().startsWith("http://")).orElse(false);
        }

        @Override
        public boolean isSink(DataFlowNode sinkNode) {
            return URI_CREATE.advanced().isAnyArgument(sinkNode.getCursor());
        }

        @Override
        public boolean isAdditionalFlowStep(DataFlowNode srcNode, DataFlowNode sinkNode) {
            return sinkNode.asExpr(BinaryExpr.class).flatMap(binary -> srcNode.asExpr().map(src -> binary.getLeft().equals(src))).orElse(false);
        }

        @Override
        public boolean isBarrierGuard(Guard guard, boolean branch) {
            return STRING_REPLACE.matches(guard.getExpression());
        }
    };

    public String getDisplayName() {
        return "URIs created with an HTTP scheme";
    }

    public String getDescription() {
        return "This is a sample recipe demonstrating a simple application of local data flow analysis.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(URI_CREATE_METHOD_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                J.Literal l = super.visitLiteral(literal, (Object)ctx);
                if (Dataflow.startingAt(this.getCursor()).findSinks(INSECURE_URI_CREATE).isPresent()) {
                    return l.withValue((Object)l.getValue().toString().replace("http://", "https://")).withValueSource(l.getValueSource().replace("http://", "https://"));
                }
                return l;
            }
        });
    }
}

