/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.openrewrite.Cursor;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.trait.expr.Expr;
import org.openrewrite.analysis.trait.variable.Parameter;

class ExpressionDataFlowNode
extends DataFlowNode {
    private final Expr expression;

    ExpressionDataFlowNode(Cursor cursor, Expr expression) {
        super(cursor);
        this.expression = Objects.requireNonNull(expression, "expression");
    }

    @Override
    public Optional<Expr> asExpr() {
        return Optional.of(this.expression);
    }

    @Override
    Optional<Parameter> asParameter() {
        return Optional.empty();
    }

    @Override
    <T> T map(Function<Expr, T> whenExpression, Function<Parameter, T> whenParameter) {
        Objects.requireNonNull(whenExpression, "whenExpression");
        Objects.requireNonNull(whenParameter, "whenParameter");
        return whenExpression.apply(this.expression);
    }
}

