/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow;

import java.util.Optional;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.analysis.controlflow.ControlFlow;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.dataflow.LocalFlowSpec;
import org.openrewrite.analysis.dataflow.analysis.ForwardFlow;
import org.openrewrite.analysis.dataflow.analysis.SinkFlow;
import org.openrewrite.analysis.dataflow.analysis.SinkFlowSummary;
import org.openrewrite.analysis.dataflow.analysis.SourceFlow;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

@Incubating(since="7.24.0")
public class Dataflow {
    @Nullable
    private final Cursor start;

    public <Source extends Expression, Sink extends J> Optional<SinkFlowSummary<Source, Sink>> findSinks(LocalFlowSpec<Source, Sink> spec) {
        if (this.start == null) {
            return Optional.empty();
        }
        Object value = this.start.getValue();
        if (spec.getSourceType().isAssignableFrom(value.getClass())) {
            Expression source = (Expression)value;
            if (!spec.isSource(DataFlowNode.of(this.start))) {
                return Optional.empty();
            }
            return ControlFlow.startingAt(this.start).findControlFlow().flatMap(summary -> {
                Set<Expression> reachable = summary.computeReachableExpressions(spec::isBarrierGuard);
                SinkFlow flow = new SinkFlow(this.start);
                ForwardFlow.findSinks(flow, spec);
                SinkFlowSummary sinkFlowSummary = SinkFlowSummary.create(flow, spec, reachable);
                return sinkFlowSummary.isNotEmpty() ? Optional.of(sinkFlowSummary) : Optional.empty();
            });
        }
        return Optional.empty();
    }

    public <E extends Expression> Optional<SourceFlow<E>> findSources(LocalFlowSpec<E, ?> spec) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    private Dataflow(@Nullable Cursor start) {
        this.start = start;
    }

    @NonNull
    public static Dataflow startingAt(@Nullable Cursor start) {
        return new Dataflow(start);
    }
}

