/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.toolingapi;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.gradle.UpdateGradleWrapper;
import org.openrewrite.gradle.marker.GradleBuildscript;
import org.openrewrite.gradle.toolingapi.GradleProject;
import org.openrewrite.gradle.toolingapi.GradleSettings;
import org.openrewrite.gradle.toolingapi.OpenRewriteModel;
import org.openrewrite.gradle.toolingapi.OpenRewriteModelBuilder;
import org.openrewrite.gradle.util.GradleWrapper;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.OperatingSystemProvenance;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.test.UncheckedConsumer;
import org.openrewrite.text.PlainText;
import org.openrewrite.toml.tree.Toml;
import org.opentest4j.TestAbortedException;

public class Assertions {
    public static UncheckedConsumer<List<SourceFile>> withToolingApi(URI distributionUrl) {
        return Assertions.withToolingApi(GradleWrapper.create((URI)distributionUrl, (ExecutionContext)new InMemoryExecutionContext()));
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi(URI distributionUrl, String initScriptContents) {
        return Assertions.withToolingApi(GradleWrapper.create((URI)distributionUrl, (ExecutionContext)new InMemoryExecutionContext()), initScriptContents);
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi(@Nullable GradleWrapper gradleWrapper) {
        return Assertions.withToolingApi(gradleWrapper, null);
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi(@Nullable GradleWrapper gradleWrapper, @Nullable String initScriptContents) {
        return sourceFiles -> {
            try {
                Path tempDirectory;
                Path projectDir = tempDirectory = Files.createTempDirectory("project", new FileAttribute[0]);
                try {
                    SourceFile sourceFile;
                    int i;
                    for (SourceFile sourceFile2 : sourceFiles) {
                        PlainText plainText;
                        if (sourceFile2 instanceof K.CompilationUnit) {
                            K.CompilationUnit k = (K.CompilationUnit)sourceFile2;
                            if (!k.getSourcePath().toString().endsWith(".gradle.kts")) continue;
                            Path kotlinGradle = tempDirectory.resolve(k.getSourcePath());
                            if (!tempDirectory.equals(kotlinGradle.getParent()) && tempDirectory.equals(kotlinGradle.getParent().getParent())) {
                                projectDir = kotlinGradle.getParent();
                            }
                            Files.createDirectories(kotlinGradle.getParent(), new FileAttribute[0]);
                            Files.write(kotlinGradle, k.printAllAsBytes(), new OpenOption[0]);
                            continue;
                        }
                        if (sourceFile2 instanceof G.CompilationUnit) {
                            G.CompilationUnit g = (G.CompilationUnit)sourceFile2;
                            if (!g.getSourcePath().toString().endsWith(".gradle")) continue;
                            Path groovyGradle = tempDirectory.resolve(g.getSourcePath());
                            if (!tempDirectory.equals(groovyGradle.getParent()) && tempDirectory.equals(groovyGradle.getParent().getParent())) {
                                projectDir = groovyGradle.getParent();
                            }
                            Files.createDirectories(groovyGradle.getParent(), new FileAttribute[0]);
                            Files.write(groovyGradle, g.printAllAsBytes(), new OpenOption[0]);
                            continue;
                        }
                        if (sourceFile2 instanceof Properties.File) {
                            Properties.File f = (Properties.File)sourceFile2;
                            if (!f.getSourcePath().endsWith("gradle.properties")) continue;
                            Path gradleProperties = tempDirectory.resolve(f.getSourcePath());
                            if (!tempDirectory.equals(gradleProperties.getParent()) && tempDirectory.equals(gradleProperties.getParent().getParent())) {
                                projectDir = gradleProperties.getParent();
                            }
                            Files.createDirectories(gradleProperties.getParent(), new FileAttribute[0]);
                            Files.write(gradleProperties, f.printAllAsBytes(), new OpenOption[0]);
                            continue;
                        }
                        if (sourceFile2 instanceof Toml.Document) {
                            Toml.Document d = (Toml.Document)sourceFile2;
                            if (!d.getSourcePath().startsWith("gradle/") || !d.getSourcePath().toString().endsWith(".versions.toml")) continue;
                            Path versionCatalog = tempDirectory.resolve(d.getSourcePath());
                            if (!tempDirectory.equals(versionCatalog.getParent()) && tempDirectory.equals(versionCatalog.getParent().getParent())) {
                                projectDir = versionCatalog.getParent();
                            }
                            Files.createDirectories(versionCatalog.getParent(), new FileAttribute[0]);
                            Files.write(versionCatalog, d.printAllAsBytes(), new OpenOption[0]);
                            continue;
                        }
                        if (!(sourceFile2 instanceof PlainText) || !(plainText = (PlainText)sourceFile2).getSourcePath().endsWith("gradle.lockfile") && !plainText.getSourcePath().endsWith("buildscript-gradle.lockfile")) continue;
                        Path lockfile = tempDirectory.resolve(plainText.getSourcePath());
                        if (!tempDirectory.equals(lockfile.getParent()) && tempDirectory.equals(lockfile.getParent().getParent())) {
                            projectDir = lockfile.getParent();
                        }
                        Files.createDirectories(lockfile.getParent(), new FileAttribute[0]);
                        Files.write(lockfile, plainText.printAllAsBytes(), new OpenOption[0]);
                    }
                    if (gradleWrapper != null) {
                        Files.createDirectories(projectDir.resolve("gradle/wrapper/"), new FileAttribute[0]);
                        Files.write(projectDir.resolve(GradleWrapper.WRAPPER_PROPERTIES_LOCATION), ("distributionBase=GRADLE_USER_HOME\ndistributionPath=wrapper/dists\ndistributionUrl=" + gradleWrapper.getPropertiesFormattedUrl() + "\n" + (gradleWrapper.getDistributionChecksum() == null ? "" : "distributionSha256Sum=" + gradleWrapper.getDistributionChecksum().getHexValue() + "\n") + "zipStoreBase=GRADLE_USER_HOME\nzipStorePath=wrapper/dists").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW);
                        Files.write(projectDir.resolve(GradleWrapper.WRAPPER_JAR_LOCATION), gradleWrapper.wrapperJar().printAllAsBytes(), StandardOpenOption.CREATE_NEW);
                        Path gradleSh = projectDir.resolve(GradleWrapper.WRAPPER_SCRIPT_LOCATION);
                        Files.copy(Objects.requireNonNull(UpdateGradleWrapper.class.getResourceAsStream("/gradlew")), gradleSh, new CopyOption[0]);
                        OperatingSystemProvenance current = OperatingSystemProvenance.current();
                        if (current.isLinux() || current.isMacOsX()) {
                            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(gradleSh, new LinkOption[0]);
                            permissions.add(PosixFilePermission.OWNER_EXECUTE);
                            Files.setPosixFilePermissions(gradleSh, permissions);
                        }
                        Files.copy(Objects.requireNonNull(UpdateGradleWrapper.class.getResourceAsStream("/gradlew.bat")), projectDir.resolve(GradleWrapper.WRAPPER_BATCH_LOCATION), new CopyOption[0]);
                    }
                    LinkedHashSet allRepositories = new LinkedHashSet();
                    LinkedHashSet allBuildscriptRepositories = new LinkedHashSet();
                    boolean freestandingScriptFound = false;
                    HashMap<String, org.openrewrite.gradle.marker.GradleProject> gradleProjects = new HashMap<String, org.openrewrite.gradle.marker.GradleProject>();
                    for (i = 0; i < sourceFiles.size(); ++i) {
                        OpenRewriteModel model;
                        sourceFile = (SourceFile)sourceFiles.get(i);
                        if (sourceFile.getSourcePath().endsWith("settings.gradle") || sourceFile.getSourcePath().endsWith("settings.gradle.kts")) {
                            model = OpenRewriteModelBuilder.forProjectDirectory(tempDirectory.resolve(sourceFile.getSourcePath()).getParent().toFile(), null, initScriptContents);
                            GradleSettings rawSettings = model.gradleSettings();
                            if (rawSettings == null) continue;
                            org.openrewrite.gradle.marker.GradleSettings gradleSettings = GradleSettings.toMarker(rawSettings);
                            sourceFiles.set(i, (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().setByType((Marker)gradleSettings)));
                            continue;
                        }
                        if (sourceFile.getSourcePath().endsWith("build.gradle") || sourceFile.getSourcePath().endsWith("build.gradle.kts")) {
                            model = OpenRewriteModelBuilder.forProjectDirectory(projectDir.toFile(), tempDirectory.resolve(sourceFile.getSourcePath()).toFile(), initScriptContents);
                            org.openrewrite.gradle.marker.GradleProject gradleProject = GradleProject.toMarker(model.gradleProject());
                            allRepositories.addAll(gradleProject.getMavenRepositories());
                            allBuildscriptRepositories.addAll(gradleProject.getBuildscript().getMavenRepositories());
                            sourceFiles.set(i, (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().setByType((Marker)gradleProject)));
                            gradleProjects.put(Assertions.getDirectory(sourceFile), GradleProject.toMarker(model.gradleProject()));
                            continue;
                        }
                        if (!sourceFile.getSourcePath().toString().endsWith(".gradle") && !sourceFile.getSourcePath().toString().endsWith(".gradle.kts")) continue;
                        freestandingScriptFound = true;
                    }
                    for (i = 0; i < sourceFiles.size(); ++i) {
                        org.openrewrite.gradle.marker.GradleProject project;
                        sourceFile = (SourceFile)sourceFiles.get(i);
                        if (!sourceFile.getSourcePath().endsWith("gradle.lockfile") && !sourceFile.getSourcePath().endsWith("buildscript-gradle.lockfile") || (project = (org.openrewrite.gradle.marker.GradleProject)gradleProjects.get(Assertions.getDirectory(sourceFile))) == null) continue;
                        sourceFiles.set(i, (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().setByType((Marker)project)));
                    }
                    if (freestandingScriptFound) {
                        org.openrewrite.gradle.marker.GradleProject freestandingScriptMarker = new org.openrewrite.gradle.marker.GradleProject(Tree.randomId(), "", "", "", "", Collections.emptyList(), new ArrayList(allRepositories), Collections.emptyList(), Collections.emptyMap(), new GradleBuildscript(Tree.randomId(), new ArrayList(allBuildscriptRepositories), Collections.emptyMap()));
                        for (int i2 = 0; i2 < sourceFiles.size(); ++i2) {
                            SourceFile sourceFile3 = (SourceFile)sourceFiles.get(i2);
                            if (!sourceFile3.getSourcePath().toString().endsWith(".gradle") && !sourceFile3.getSourcePath().toString().endsWith(".gradle.kts") || sourceFile3.getMarkers().findFirst(org.openrewrite.gradle.marker.GradleProject.class).isPresent() || sourceFile3.getMarkers().findFirst(org.openrewrite.gradle.marker.GradleSettings.class).isPresent()) continue;
                            sourceFiles.set(i2, (SourceFile)sourceFile3.withMarkers(sourceFile3.getMarkers().add((Marker)freestandingScriptMarker)));
                        }
                    }
                }
                finally {
                    Assertions.deleteDirectory(tempDirectory.toFile());
                }
            }
            catch (IOException e) {
                throw new TestAbortedException("Failed to load Gradle tooling API", (Throwable)e);
            }
        };
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi(@Nullable String version, @Nullable String distribution) {
        GradleWrapper gradleWrapper = null;
        if (version != null) {
            gradleWrapper = GradleWrapper.create((String)distribution, (String)version, (ExecutionContext)new InMemoryExecutionContext());
        }
        return Assertions.withToolingApi(gradleWrapper);
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi(String version) {
        return Assertions.withToolingApi(version, "bin");
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi() {
        return Assertions.withToolingApi((GradleWrapper)null, null);
    }

    private static void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                Assertions.deleteDirectory(file);
            }
        }
        directoryToBeDeleted.delete();
    }

    private static String getDirectory(SourceFile file) {
        Path sourcePath = file.getSourcePath();
        Path parent = sourcePath.getParent();
        if (parent != null) {
            return parent.toString();
        }
        return "";
    }
}

