/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.marker;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.gradle.marker.FeaturePreview;
import org.openrewrite.gradle.marker.GradlePluginDescriptor;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.tree.MavenRepository;

public final class GradleSettings
implements Marker,
Serializable {
    private final UUID id;
    private final List<MavenRepository> pluginRepositories;
    private final List<GradlePluginDescriptor> plugins;
    private final Map<String, FeaturePreview> featurePreviews;

    public boolean isFeatureEnabled(String name) {
        return this.featurePreviews.get(name).isEnabled();
    }

    public Set<FeaturePreview> getActiveFeatures() {
        return this.featurePreviews.values().stream().filter(FeaturePreview::isActive).collect(Collectors.toSet());
    }

    public static GradleSettings fromToolingModel(org.openrewrite.gradle.toolingapi.GradleSettings settings) {
        return new GradleSettings(UUID.randomUUID(), settings.getPluginRepositories().stream().map(GradleProject::fromToolingModel).collect(Collectors.toList()), settings.getPlugins().stream().map(GradlePluginDescriptor::fromToolingModel).collect(Collectors.toList()), GradleSettings.fromToolingModel(settings.getFeaturePreviews()));
    }

    private static Map<String, FeaturePreview> fromToolingModel(Map<String, org.openrewrite.gradle.toolingapi.FeaturePreview> toolingFeaturePreviews) {
        HashMap<String, FeaturePreview> results = new HashMap<String, FeaturePreview>();
        for (Map.Entry<String, org.openrewrite.gradle.toolingapi.FeaturePreview> featurePreviewEntry : toolingFeaturePreviews.entrySet()) {
            results.put(featurePreviewEntry.getKey(), FeaturePreview.fromToolingModel(featurePreviewEntry.getValue()));
        }
        return results;
    }

    public GradleSettings(UUID id, List<MavenRepository> pluginRepositories, List<GradlePluginDescriptor> plugins, Map<String, FeaturePreview> featurePreviews) {
        this.id = id;
        this.pluginRepositories = pluginRepositories;
        this.plugins = plugins;
        this.featurePreviews = featurePreviews;
    }

    public UUID getId() {
        return this.id;
    }

    public List<MavenRepository> getPluginRepositories() {
        return this.pluginRepositories;
    }

    public List<GradlePluginDescriptor> getPlugins() {
        return this.plugins;
    }

    public Map<String, FeaturePreview> getFeaturePreviews() {
        return this.featurePreviews;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleSettings)) {
            return false;
        }
        GradleSettings other = (GradleSettings)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List<MavenRepository> this$pluginRepositories = this.getPluginRepositories();
        List<MavenRepository> other$pluginRepositories = other.getPluginRepositories();
        if (this$pluginRepositories == null ? other$pluginRepositories != null : !((Object)this$pluginRepositories).equals(other$pluginRepositories)) {
            return false;
        }
        List<GradlePluginDescriptor> this$plugins = this.getPlugins();
        List<GradlePluginDescriptor> other$plugins = other.getPlugins();
        if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
            return false;
        }
        Map<String, FeaturePreview> this$featurePreviews = this.getFeaturePreviews();
        Map<String, FeaturePreview> other$featurePreviews = other.getFeaturePreviews();
        return !(this$featurePreviews == null ? other$featurePreviews != null : !((Object)this$featurePreviews).equals(other$featurePreviews));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List<MavenRepository> $pluginRepositories = this.getPluginRepositories();
        result = result * 59 + ($pluginRepositories == null ? 43 : ((Object)$pluginRepositories).hashCode());
        List<GradlePluginDescriptor> $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        Map<String, FeaturePreview> $featurePreviews = this.getFeaturePreviews();
        result = result * 59 + ($featurePreviews == null ? 43 : ((Object)$featurePreviews).hashCode());
        return result;
    }

    public String toString() {
        return "GradleSettings(id=" + this.getId() + ", pluginRepositories=" + this.getPluginRepositories() + ", plugins=" + this.getPlugins() + ", featurePreviews=" + this.getFeaturePreviews() + ")";
    }

    public GradleSettings withId(UUID id) {
        return this.id == id ? this : new GradleSettings(id, this.pluginRepositories, this.plugins, this.featurePreviews);
    }

    public GradleSettings withPluginRepositories(List<MavenRepository> pluginRepositories) {
        return this.pluginRepositories == pluginRepositories ? this : new GradleSettings(this.id, pluginRepositories, this.plugins, this.featurePreviews);
    }

    public GradleSettings withPlugins(List<GradlePluginDescriptor> plugins) {
        return this.plugins == plugins ? this : new GradleSettings(this.id, this.pluginRepositories, plugins, this.featurePreviews);
    }

    public GradleSettings withFeaturePreviews(Map<String, FeaturePreview> featurePreviews) {
        return this.featurePreviews == featurePreviews ? this : new GradleSettings(this.id, this.pluginRepositories, this.plugins, featurePreviews);
    }
}

