/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.marker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradlePluginDescriptor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.tree.MavenRepository;

public final class GradleProject
implements Marker,
Serializable {
    private final UUID id;
    private final String name;
    private final String path;
    private final List<GradlePluginDescriptor> plugins;
    private final List<MavenRepository> mavenRepositories;
    private final Map<String, GradleDependencyConfiguration> nameToConfiguration;

    @Nullable
    public GradleDependencyConfiguration getConfiguration(String name) {
        return this.nameToConfiguration.get(name);
    }

    public List<GradleDependencyConfiguration> getConfigurations() {
        return new ArrayList<GradleDependencyConfiguration>(this.nameToConfiguration.values());
    }

    public List<GradleDependencyConfiguration> configurationsExtendingFrom(GradleDependencyConfiguration parentConfiguration, boolean transitive) {
        ArrayList<GradleDependencyConfiguration> result = new ArrayList<GradleDependencyConfiguration>();
        for (GradleDependencyConfiguration configuration : this.nameToConfiguration.values()) {
            if (configuration == parentConfiguration) continue;
            for (GradleDependencyConfiguration extendsFrom : configuration.getExtendsFrom()) {
                if (extendsFrom != parentConfiguration) continue;
                result.add(configuration);
                if (!transitive) continue;
                result.addAll(this.configurationsExtendingFrom(configuration, true));
            }
        }
        return result;
    }

    public GradleProject withNameToConfiguration(Map<String, GradleDependencyConfiguration> nameToConfiguration) {
        HashMap<String, GradleDependencyConfiguration> configurations = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration);
        for (GradleDependencyConfiguration gdc : configurations.values()) {
            ArrayList<GradleDependencyConfiguration> extendsFromList = new ArrayList<GradleDependencyConfiguration>(gdc.getExtendsFrom());
            boolean changed = false;
            for (int i = 0; i < extendsFromList.size(); ++i) {
                GradleDependencyConfiguration extendsFrom = (GradleDependencyConfiguration)extendsFromList.get(i);
                if (configurations.get(extendsFrom.getName()) == extendsFrom) continue;
                extendsFromList.set(i, (GradleDependencyConfiguration)configurations.get(extendsFrom.getName()));
                changed = true;
            }
            if (!changed) continue;
            configurations.put(gdc.getName(), gdc.withExtendsFrom(extendsFromList));
        }
        return new GradleProject(this.id, this.name, this.path, this.plugins, this.mavenRepositories, configurations);
    }

    public static GradleProject fromToolingModel(org.openrewrite.gradle.toolingapi.GradleProject project) {
        return new GradleProject(UUID.randomUUID(), project.getName(), project.getPath(), project.getPlugins().stream().map(GradlePluginDescriptor::fromToolingModel).collect(Collectors.toList()), project.getMavenRepositories().stream().map(GradleProject::fromToolingModel).collect(Collectors.toList()), GradleDependencyConfiguration.fromToolingModel(project.getNameToConfiguration()));
    }

    @Nullable
    static MavenRepository fromToolingModel(@Nullable org.openrewrite.gradle.toolingapi.MavenRepository mavenRepository) {
        if (mavenRepository == null) {
            return null;
        }
        return new MavenRepository(mavenRepository.getId(), mavenRepository.getUri(), mavenRepository.getReleases(), mavenRepository.getSnapshots(), mavenRepository.isKnownToExist(), mavenRepository.getUsername(), mavenRepository.getPassword(), mavenRepository.getDeriveMetadataIfMissing());
    }

    public GradleProject(UUID id, String name, String path, List<GradlePluginDescriptor> plugins, List<MavenRepository> mavenRepositories, Map<String, GradleDependencyConfiguration> nameToConfiguration) {
        this.id = id;
        this.name = name;
        this.path = path;
        this.plugins = plugins;
        this.mavenRepositories = mavenRepositories;
        this.nameToConfiguration = nameToConfiguration;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public List<GradlePluginDescriptor> getPlugins() {
        return this.plugins;
    }

    public List<MavenRepository> getMavenRepositories() {
        return this.mavenRepositories;
    }

    public Map<String, GradleDependencyConfiguration> getNameToConfiguration() {
        return this.nameToConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleProject)) {
            return false;
        }
        GradleProject other = (GradleProject)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List<GradlePluginDescriptor> this$plugins = this.getPlugins();
        List<GradlePluginDescriptor> other$plugins = other.getPlugins();
        if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
            return false;
        }
        List<MavenRepository> this$mavenRepositories = this.getMavenRepositories();
        List<MavenRepository> other$mavenRepositories = other.getMavenRepositories();
        if (this$mavenRepositories == null ? other$mavenRepositories != null : !((Object)this$mavenRepositories).equals(other$mavenRepositories)) {
            return false;
        }
        Map<String, GradleDependencyConfiguration> this$nameToConfiguration = this.getNameToConfiguration();
        Map<String, GradleDependencyConfiguration> other$nameToConfiguration = other.getNameToConfiguration();
        return !(this$nameToConfiguration == null ? other$nameToConfiguration != null : !((Object)this$nameToConfiguration).equals(other$nameToConfiguration));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        List<GradlePluginDescriptor> $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        List<MavenRepository> $mavenRepositories = this.getMavenRepositories();
        result = result * 59 + ($mavenRepositories == null ? 43 : ((Object)$mavenRepositories).hashCode());
        Map<String, GradleDependencyConfiguration> $nameToConfiguration = this.getNameToConfiguration();
        result = result * 59 + ($nameToConfiguration == null ? 43 : ((Object)$nameToConfiguration).hashCode());
        return result;
    }

    public String toString() {
        return "GradleProject(id=" + this.getId() + ", name=" + this.getName() + ", path=" + this.getPath() + ", plugins=" + this.getPlugins() + ", mavenRepositories=" + this.getMavenRepositories() + ", nameToConfiguration=" + this.getNameToConfiguration() + ")";
    }

    public GradleProject withId(UUID id) {
        return this.id == id ? this : new GradleProject(id, this.name, this.path, this.plugins, this.mavenRepositories, this.nameToConfiguration);
    }

    public GradleProject withName(String name) {
        return this.name == name ? this : new GradleProject(this.id, name, this.path, this.plugins, this.mavenRepositories, this.nameToConfiguration);
    }

    public GradleProject withPath(String path) {
        return this.path == path ? this : new GradleProject(this.id, this.name, path, this.plugins, this.mavenRepositories, this.nameToConfiguration);
    }

    public GradleProject withPlugins(List<GradlePluginDescriptor> plugins) {
        return this.plugins == plugins ? this : new GradleProject(this.id, this.name, this.path, plugins, this.mavenRepositories, this.nameToConfiguration);
    }

    public GradleProject withMavenRepositories(List<MavenRepository> mavenRepositories) {
        return this.mavenRepositories == mavenRepositories ? this : new GradleProject(this.id, this.name, this.path, this.plugins, mavenRepositories, this.nameToConfiguration);
    }
}

