/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.io;

import com.ochafik.util.progress.ProgressModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class IOUtils {
    public static final long readWrite(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] b = new byte[4096];
        long total = 0L;
        while ((len = in.read(b)) > 0) {
            out.write(b, 0, len);
            total += (long)len;
        }
        return total;
    }

    public static final long readWrite(InputStream in, OutputStream out, int maxLen) throws IOException {
        int len;
        int allowed;
        int bLen = 4096;
        byte[] b = new byte[bLen];
        long total = 0L;
        int n = allowed = bLen <= maxLen ? bLen : maxLen;
        while (allowed > 0 && (len = in.read(b, 0, allowed)) > 0) {
            out.write(b, 0, len);
            total += (long)len;
            allowed = bLen <= (maxLen -= len) ? bLen : maxLen;
        }
        return total;
    }

    public static final long readWrite(InputStream in, OutputStream out, ProgressModel progressModel) throws IOException {
        int len;
        byte[] b = new byte[1024];
        long total = 0L;
        while ((len = in.read(b)) > 0) {
            out.write(b, 0, len);
            total += (long)len;
            progressModel.addProgress(len);
        }
        return total;
    }

    public static void readWrite(Reader in, Writer out) throws IOException {
        int len;
        char[] b = new char[1024];
        long total = 0L;
        while ((len = in.read(b)) > 0) {
            out.write(b, 0, len);
            total += (long)len;
        }
    }
}

