/*
 * Decompiled with CFR 0.152.
 */
package org.openpnp.capture;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openpnp.capture.CaptureFormat;
import org.openpnp.capture.CaptureStream;
import org.openpnp.capture.library.CapFormatInfo;
import org.openpnp.capture.library.OpenpnpCaptureLibrary;

public class CaptureDevice {
    final Pointer context;
    final int index;
    final String name;
    final String uniqueId;
    final List<CaptureFormat> formats = new ArrayList<CaptureFormat>();

    public CaptureDevice(Pointer context, int index) {
        this.context = context;
        this.index = index;
        this.name = OpenpnpCaptureLibrary.INSTANCE.Cap_getDeviceName(context, index).getString(0L, "UTF8");
        this.uniqueId = OpenpnpCaptureLibrary.INSTANCE.Cap_getDeviceUniqueID(context, index).getString(0L, "UTF8");
        int formatCount = OpenpnpCaptureLibrary.INSTANCE.Cap_getNumFormats(context, index);
        for (int formatIndex = 0; formatIndex < formatCount; ++formatIndex) {
            CapFormatInfo formatInfo = new CapFormatInfo();
            OpenpnpCaptureLibrary.INSTANCE.Cap_getFormatInfo(context, index, formatIndex, formatInfo);
            this.formats.add(new CaptureFormat(formatIndex, formatInfo));
        }
    }

    public CaptureStream openStream(CaptureFormat format) {
        int id = OpenpnpCaptureLibrary.INSTANCE.Cap_openStream(this.context, this.index, format.formatId);
        if (id == -1) {
            return null;
        }
        return new CaptureStream(this.context, id, format);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public List<CaptureFormat> getFormats() {
        return Collections.unmodifiableList(this.formats);
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CaptureDevice)) {
            return false;
        }
        CaptureDevice dev = (CaptureDevice)obj;
        return dev.uniqueId.equals(this.uniqueId);
    }
}

