/*
 * Decompiled with CFR 0.152.
 */
package org.openpnp.capture;

import com.sun.jna.Pointer;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.openpnp.capture.CaptureDevice;
import org.openpnp.capture.CaptureFormat;
import org.openpnp.capture.CaptureStream;
import org.openpnp.capture.library.OpenpnpCaptureLibrary;

public class OpenPnpCapture {
    Pointer context = OpenpnpCaptureLibrary.INSTANCE.Cap_createContext();

    public List<CaptureDevice> getDevices() {
        int deviceCount = OpenpnpCaptureLibrary.INSTANCE.Cap_getDeviceCount(this.context);
        ArrayList<CaptureDevice> devices = new ArrayList<CaptureDevice>();
        for (int deviceIndex = 0; deviceIndex < deviceCount; ++deviceIndex) {
            CaptureDevice device = new CaptureDevice(this.context, deviceIndex);
            devices.add(device);
        }
        return devices;
    }

    public void close() {
        OpenpnpCaptureLibrary.INSTANCE.Cap_releaseContext(this.context);
    }

    public Pointer getContext() {
        return this.context;
    }

    public String getLibraryVersion() {
        return OpenpnpCaptureLibrary.INSTANCE.Cap_getLibraryVersion().getString(0L, "UTF8");
    }

    public static String getResultDescription(int result) {
        switch (result) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "Error";
            }
            case 2: {
                return "Device Not Found";
            }
            case 3: {
                return "Format Not Supported";
            }
            case 4: {
                return "Property Not Supported";
            }
        }
        return "" + result;
    }

    public static String fourCcToString(int fourCc) {
        String s = "";
        for (int i = 0; i < 4; ++i) {
            s = s + (char)(fourCc & 0xFF);
            fourCc >>= 8;
        }
        return s;
    }

    public static void main(String[] args) {
        OpenPnpCapture capture = new OpenPnpCapture();
        CaptureDevice device = capture.getDevices().get(0);
        CaptureFormat format = device.getFormats().get(0);
        CaptureStream stream = device.openStream(format);
        BufferedImage image = stream.capture();
    }
}

