/*
 * Decompiled with CFR 0.152.
 */
package org.openpnp.capture;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import org.openpnp.capture.CaptureDevice;
import org.openpnp.capture.library.OpenpnpCaptureLibrary;

public class OpenPnpCapture {
    Pointer context = OpenpnpCaptureLibrary.INSTANCE.Cap_createContext();

    public List<CaptureDevice> getDevices() {
        int deviceCount = OpenpnpCaptureLibrary.INSTANCE.Cap_getDeviceCount(this.context);
        ArrayList<CaptureDevice> devices = new ArrayList<CaptureDevice>();
        for (int deviceIndex = 0; deviceIndex < deviceCount; ++deviceIndex) {
            CaptureDevice device = new CaptureDevice(this.context, deviceIndex);
            devices.add(device);
        }
        return devices;
    }

    public void close() {
        OpenpnpCaptureLibrary.INSTANCE.Cap_releaseContext(this.context);
    }

    public static String fourCcToString(int fourCc) {
        String s = "";
        for (int i = 0; i < 4; ++i) {
            s = s + (char)(fourCc & 0xFF);
            fourCc >>= 8;
        }
        return s;
    }

    public static void main(String[] args) {
        OpenPnpCapture capture = new OpenPnpCapture();
        List<CaptureDevice> devices = capture.getDevices();
        System.out.println(devices);
    }
}

