/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample.health;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.opennms.integration.api.sample.SampleCollector;
import org.opennms.integration.api.sample.SamplePoller;
import org.opennms.integration.api.v1.collectors.CollectionRequest;
import org.opennms.integration.api.v1.collectors.CollectionSet;
import org.opennms.integration.api.v1.collectors.ServiceCollectorClient;
import org.opennms.integration.api.v1.dao.NodeDao;
import org.opennms.integration.api.v1.detectors.DetectorClient;
import org.opennms.integration.api.v1.health.Context;
import org.opennms.integration.api.v1.health.HealthCheck;
import org.opennms.integration.api.v1.health.Response;
import org.opennms.integration.api.v1.health.Status;
import org.opennms.integration.api.v1.health.immutables.ImmutableResponse;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.pollers.PollerResult;
import org.opennms.integration.api.v1.pollers.ServicePollerClient;

public class ServiceExtensionHealthCheck
implements HealthCheck {
    private final DetectorClient detectorClient;
    private final ServicePollerClient pollerClient;
    private final ServiceCollectorClient collectorClient;
    private final NodeDao nodeDao;

    public ServiceExtensionHealthCheck(DetectorClient detectorClient, ServicePollerClient pollerClient, ServiceCollectorClient collectorClient, NodeDao nodeDao) {
        this.detectorClient = Objects.requireNonNull(detectorClient);
        this.pollerClient = Objects.requireNonNull(pollerClient);
        this.collectorClient = Objects.requireNonNull(collectorClient);
        this.nodeDao = Objects.requireNonNull(nodeDao);
    }

    public String getDescription() {
        return "OIA :: Sample Project :: Service Extensions";
    }

    public Response perform(Context context) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("username", "admin");
        attributes.put("password", "admin");
        CompletableFuture future = this.detectorClient.detect("Sample", "localhost", attributes);
        try {
            if (!((Boolean)future.get()).booleanValue()) {
                return ImmutableResponse.newInstance((Status)Status.Failure, (String)"Sample Detector detection failed");
            }
        }
        catch (Exception e) {
            return ImmutableResponse.newInstance((Exception)e);
        }
        try {
            CompletableFuture pollerStatus = this.pollerClient.poll().withAddress(InetAddress.getLocalHost()).withPollerClassName(SamplePoller.class.getCanonicalName()).withServiceName("Sample").execute();
            if (!((PollerResult)pollerStatus.get()).getStatus().equals((Object)org.opennms.integration.api.v1.pollers.Status.Up)) {
                return ImmutableResponse.newInstance((Status)Status.Failure, (String)((PollerResult)pollerStatus.get()).getReason());
            }
        }
        catch (Exception e) {
            return ImmutableResponse.newInstance((Exception)e);
        }
        Optional<Node> node = this.getFirstNodeWithInterfaceAtDefaultLocation();
        if (!node.isPresent()) {
            return ImmutableResponse.newInstance((Status)Status.Success);
        }
        try {
            CompletableFuture collectionSetFuture = this.collectorClient.collect().withCollectorClassName(SampleCollector.class.getCanonicalName()).withRequest((CollectionRequest)new SampleCollector.CollectionRequestImpl(node.get().getId())).execute();
            CollectionSet collectionResult = (CollectionSet)collectionSetFuture.get();
            if (collectionResult.getStatus().equals((Object)CollectionSet.Status.SUCCEEDED)) {
                if (SampleCollector.validateCollectionSet(collectionResult)) {
                    return ImmutableResponse.newInstance((Status)Status.Success);
                }
                return ImmutableResponse.newInstance((Status)Status.Failure, (String)"Collection set didn't match");
            }
            return ImmutableResponse.newInstance((Status)Status.Failure, (String)"Sample Collector Collection Failed");
        }
        catch (Exception e) {
            return ImmutableResponse.newInstance((Exception)e);
        }
    }

    private Optional<Node> getFirstNodeWithInterfaceAtDefaultLocation() {
        return this.nodeDao.getNodesInLocation(this.nodeDao.getDefaultLocationName()).stream().filter(n -> !n.getIpInterfaces().isEmpty()).findFirst();
    }
}

