/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.opennms.integration.api.sample.AlarmTestContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequisitionTestContextManager {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmTestContextManager.class);
    private final AtomicLong sessionIdGenerator = new AtomicLong(System.currentTimeMillis());
    protected static final String SESSION_ID_PARM_NAME = "sessionId";
    private final Map<Long, RequisitionTestSession> sessionsById = new ConcurrentHashMap<Long, RequisitionTestSession>();

    public RequisitionTestSession newSession() {
        long sessionId = this.sessionIdGenerator.incrementAndGet();
        RequisitionTestSession session = new RequisitionTestSession(sessionId);
        this.sessionsById.put(sessionId, session);
        return session;
    }

    public void trackGetRequisitionForSession(String sessionIdAsString) {
        Long sessionId;
        try {
            sessionId = Long.parseLong(sessionIdAsString);
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Invalid session id '{}'. Ignoring.", (Object)sessionIdAsString);
            return;
        }
        this.trackGetRequisitionForSession(sessionId);
    }

    public void trackGetRequisitionForSession(Long sessionId) {
        RequisitionTestSession session = this.sessionsById.get(sessionId);
        if (session == null) {
            return;
        }
        session.trackGetRequisition();
    }

    public class RequisitionTestSession
    implements AutoCloseable {
        private final long sessionId;
        private CountDownLatch getLatch = new CountDownLatch(1);

        public RequisitionTestSession(long sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public void close() {
            RequisitionTestContextManager.this.sessionsById.remove(this.sessionId);
        }

        private void trackGetRequisition() {
            this.getLatch.countDown();
        }

        public void waitForGet() throws InterruptedException {
            this.getLatch.await();
        }

        public String getSessionId() {
            return Long.toString(this.sessionId);
        }
    }
}

