/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample;

import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.sample.AlarmTestContextManager;
import org.opennms.integration.api.v1.alarms.AlarmLifecycleListener;
import org.opennms.integration.api.v1.model.Alarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyAlarmLifecycleListener
implements AlarmLifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(MyAlarmLifecycleListener.class);
    private final AlarmTestContextManager alarmManager;

    public MyAlarmLifecycleListener(AlarmTestContextManager alarmManager) {
        this.alarmManager = Objects.requireNonNull(alarmManager);
    }

    public void handleAlarmSnapshot(List<Alarm> alarms) {
        LOG.info("handleAlarmSnapshot called with {} alarms.", (Object)alarms.size());
    }

    public void handleNewOrUpdatedAlarm(Alarm alarm) {
        LOG.info("handleNewOrUpdatedAlarm called for alarm with id: {} and reduction key: {}", (Object)alarm.getId(), (Object)alarm.getReductionKey());
        this.alarmManager.handleNewOrUpdatedAlarm(alarm);
    }

    public void handleDeletedAlarm(int alarmId, String reductionKey) {
        LOG.info("handleDeletedAlarm called for alarm with id: {} and reduction key: {}", (Object)alarmId, (Object)reductionKey);
    }
}

