/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.timeseries.immutables;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.timeseries.Tag;

class MetricValidator {
    private final Set<Tag> intrinsicTags;
    private final Set<Tag> metaTags;

    public MetricValidator(Set<Tag> intrinsicTags, Set<Tag> metaTags) {
        this.intrinsicTags = intrinsicTags;
        this.metaTags = metaTags;
    }

    public Set<Tag> getTagsByKey(String key) {
        return this.intrinsicTags.stream().filter(t -> Objects.equals(t.getKey(), key)).collect(Collectors.toSet());
    }

    public void validate() {
        this.requireNonNullTagSets();
        this.requireAtLeastOneIntrinsicTagToBePresent();
    }

    private void requireNonNullTagSets() {
        Objects.requireNonNull(this.intrinsicTags);
        Objects.requireNonNull(this.metaTags);
    }

    private void requireAtLeastOneIntrinsicTagToBePresent() {
        if (this.intrinsicTags.isEmpty()) {
            throw new IllegalArgumentException("At least one intrinsic tag is required");
        }
    }
}

