/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.collectors.resource.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.collectors.resource.NodeResource;
import org.opennms.integration.api.v1.collectors.resource.Resource;

public final class ImmutableNodeResource
implements NodeResource {
    private final Integer nodeId;
    private final String foreignSource;
    private final String foreignId;
    private final String nodeLabel;
    private final String location;

    private ImmutableNodeResource(Builder builder) {
        this.nodeId = builder.nodeId;
        this.foreignSource = builder.foreignSource;
        this.foreignId = builder.foreignId;
        this.nodeLabel = builder.nodeLabel;
        this.location = builder.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(NodeResource nodeResource) {
        return new Builder(nodeResource);
    }

    public static NodeResource immutableCopy(NodeResource nodeResource) {
        if (nodeResource == null || nodeResource instanceof ImmutableNodeResource) {
            return nodeResource;
        }
        return ImmutableNodeResource.newBuilderFrom(nodeResource).build();
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public String getForeignSource() {
        return this.foreignSource;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public String getLocation() {
        return this.location;
    }

    public Resource.Type getResourceType() {
        return Resource.Type.NODE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableNodeResource that = (ImmutableNodeResource)o;
        return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.foreignSource, that.foreignSource) && Objects.equals(this.foreignId, that.foreignId) && Objects.equals(this.nodeLabel, that.nodeLabel) && Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.foreignSource, this.foreignId, this.nodeLabel, this.location);
    }

    public String toString() {
        return "ImmutableNodeResource{nodeId=" + this.nodeId + ", foreignSource='" + this.foreignSource + '\'' + ", foreignId='" + this.foreignId + '\'' + ", nodeLabel='" + this.nodeLabel + '\'' + ", location='" + this.location + '\'' + '}';
    }

    public static final class Builder {
        private Integer nodeId;
        private String foreignSource;
        private String foreignId;
        private String nodeLabel;
        private String location;

        private Builder() {
        }

        private Builder(NodeResource nodeResource) {
            this.nodeId = nodeResource.getNodeId();
            this.foreignSource = nodeResource.getForeignSource();
            this.foreignId = nodeResource.getForeignId();
            this.nodeLabel = nodeResource.getNodeLabel();
            this.location = nodeResource.getLocation();
        }

        public Builder setNodeId(Integer nodeId) {
            this.nodeId = Objects.requireNonNull(nodeId);
            return this;
        }

        public Builder setForeignSource(String foreignSource) {
            this.foreignSource = foreignSource;
            return this;
        }

        public Builder setForeignId(String foreignId) {
            this.foreignId = foreignId;
            return this;
        }

        public Builder setNodeLabel(String nodeLabel) {
            this.nodeLabel = nodeLabel;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ImmutableNodeResource build() {
            Objects.requireNonNull(this.nodeId, "nodeId is required");
            return new ImmutableNodeResource(this);
        }
    }
}

