/*
 * This work is part of OpenLDAP Software <http://www.openldap.org/>.
 *
 *  Copyright 1998-2014 The OpenLDAP Foundation.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted only as authorized by the OpenLDAP
 *  Public License.
 *
 *  A copy of this license is available in the file LICENSE in the
 *  top-level directory of the distribution or, alternatively, at
 *  <http://www.OpenLDAP.org/license.html>.
 */
package org.openldap.accelerator.api.sessionRoles;


import org.apache.directory.api.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;

import java.util.ArrayList;
import java.util.List;


/**
 * The RbacSessionRoles response
 * 
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class RbacSessionRolesResponseImpl extends ExtendedResponseImpl implements RbacSessionRolesResponse
{
    /** The list of requested roles */
    private List<String> roles;

    
    /**
     * Create a new instance for the RbacSessionRoles response
     * @param messageId The Message ID
     * @param rcode The result code
     * @param diagnosticMessage The diagnostic message
     */
    public RbacSessionRolesResponseImpl( int messageId, ResultCodeEnum rcode, String diagnosticMessage )
    {
        super( messageId, EXTENSION_OID );

        super.getLdapResult().setMatchedDn( null );
        super.getLdapResult().setResultCode( rcode );
        super.getLdapResult().setDiagnosticMessage( diagnosticMessage );
    }


    /**
     * Create a new instance for the RbacSessionRoles response
     * @param messageId The Message ID
     * @param rcode The result code
     */
    public RbacSessionRolesResponseImpl( int messageId, ResultCodeEnum rcode )
    {
        super( messageId, EXTENSION_OID );
        super.getLdapResult().setMatchedDn( null );
        super.getLdapResult().setResultCode( rcode );
    }


    /**
     * Instantiates a new RbacSessionRoles response.
     *
     * @param messageId the message id
     */
    public RbacSessionRolesResponseImpl( int messageId )
    {
        super( messageId, EXTENSION_OID );
        super.getLdapResult().setMatchedDn( null );
        super.getLdapResult().setResultCode( ResultCodeEnum.SUCCESS );
    }


    /**
     * Instantiates a new RbacSessionRoles response.
     */
    public RbacSessionRolesResponseImpl()
    {
        super( EXTENSION_OID );
        super.getLdapResult().setMatchedDn( null );
        super.getLdapResult().setResultCode( ResultCodeEnum.SUCCESS );
    }


    /**
     * @return the roles
     */
    public List<String> getRoles()
    {
        return roles;
    }


    /**
     * @param roles the roles to set
     */
    public void setRoles( List<String> roles )
    {
        if ( roles != null )
        {
            this.roles = new ArrayList<String>( roles.size() );

            this.roles.addAll( roles );
        }
    }


    /**
     * @param role the role to add
     */
    public void addRole( String role )
    {
        if ( roles == null )
        {
            roles = new ArrayList<String>();
        }

        roles.add( role );
    }


    /**
     * @see Object#toString()
     */
    public String toString()
    {
        StringBuilder sb = new StringBuilder();
        sb.append( "RbacSessionRoles response :" );
        if ( roles != null )
        {
            sb.append( "\n    roles : {" );
            if ( roles.size() != 0 )
            {
                boolean isFirst = true;
                for ( String role : roles )
                {
                    if ( isFirst )
                    {
                        isFirst = false;
                    }
                    else
                    {
                        sb.append( ", " );
                    }

                    sb.append( role );
                }
            }

            sb.append( "}" );
        }
        return sb.toString();
    }
}
