/*
 * This work is part of OpenLDAP Software <http://www.openldap.org/>.
 *
 *  Copyright 1998-2014 The OpenLDAP Foundation.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted only as authorized by the OpenLDAP
 *  Public License.
 *
 *  A copy of this license is available in the file LICENSE in the
 *  top-level directory of the distribution or, alternatively, at
 *  <http://www.OpenLDAP.org/license.html>.
 */
package org.openldap.accelerator.api.sessionRoles;


import org.apache.directory.api.ldap.model.message.ExtendedResponse;

import java.util.List;


/**
 * RbacSessionRolesResponse extended operation interface.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public interface RbacSessionRolesResponse extends ExtendedResponse
{
    /** The responseName for this extended response */
    static final String EXTENSION_OID = "1.3.6.1.4.1.4203.555.6";

    /**
     * @return the roles
     */
    List<String> getRoles();


    /**
     * @param roles the roles to set
     */
    void setRoles( List<String> roles );


    /**
     * @param role the role to add
     */
    void addRole( String role );

}
