/*
 * This work is part of OpenLDAP Software <http://www.openldap.org/>.
 *
 *  Copyright 1998-2014 The OpenLDAP Foundation.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted only as authorized by the OpenLDAP
 *  Public License.
 *
 *  A copy of this license is available in the file LICENSE in the
 *  top-level directory of the distribution or, alternatively, at
 *  <http://www.OpenLDAP.org/license.html>.
 */
package org.openldap.accelerator.api.dropRole;


import org.apache.directory.api.ldap.model.message.AbstractExtendedRequest;


/**
 * RbacDropRoleRequest extended operation implementation.
 * 
 * It follows the ASN.1 description for this operation :
 * <pre>
 * RbacDropRoleRequest ::= SEQUENCE {
 *       userIdentity  [0] OCTET STRING,
 *       sessionId     [1] OCTET STRING,
 *       role          [2] OCTET STRING
 * }
 * </pre>
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class RbacDropRoleRequestImpl extends AbstractExtendedRequest implements RbacDropRoleRequest
{
    /** The session ID */
    private String sessionId;

    /** The user's identity */
    private String userIdentity;

    /** The role to add */
    private String role;


    /**
     * Create a new instance of the RbacDropRoleRequestImpl extended operation
     */
    public RbacDropRoleRequestImpl()
    {
        setRequestName( EXTENSION_OID );
    }


    /**
     * Create a new instance of the RbacDropRoleRequestImpl extended operation
     * 
     * @param messageId The message ID
     */
    public RbacDropRoleRequestImpl( int messageId )
    {
        super( messageId );
        setRequestName( EXTENSION_OID );
    }


    /**
     * @return The session ID
     */
    public String getSessionId()
    {
        return sessionId;
    }


    /**
     * Sets the session ID
     * 
     * @param sessionID the session ID to set
     */
    public void setSessionId( String sessionID )
    {
        this.sessionId = sessionID;
    }


    /**
     * @return the userIdentity
     */
    public String getUserIdentity()
    {
        return userIdentity;
    }


    /**
     * @param userIdentity the userIdentity to set
     */
    public void setUserIdentity( String userIdentity )
    {
        this.userIdentity = userIdentity;
    }


    /**
     * @return the role
     */
    public String getRole()
    {
        return role;
    }


    /**
     * @param role the role to add
     */
    public void setRole( String role )
    {
        this.role = role;
    }
    


    @Override
    public RbacDropRoleResponse getResultResponse()
    {
        if ( getResponse() == null )
        {
            setResponse( new RbacDropRoleResponseImpl() );
        }

        return null;
    }

    
    /**
     * @see Object#toString()
     */
    public String toString()
    {
        StringBuilder sb = new StringBuilder();

        sb.append( "RbacDropRoleRequest :" );
        sb.append( "\n    sessionId : " ).append( sessionId );
        sb.append( "\n    userIdentity : " ).append( userIdentity );
        sb.append( "\n    role : " ).append( role );
        
        return sb.toString();
    }
}
