/*
 * This work is part of OpenLDAP Software <http://www.openldap.org/>.
 *
 *  Copyright 1998-2014 The OpenLDAP Foundation.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted only as authorized by the OpenLDAP
 *  Public License.
 *
 *  A copy of this license is available in the file LICENSE in the
 *  top-level directory of the distribution or, alternatively, at
 *  <http://www.OpenLDAP.org/license.html>.
 */
package org.openldap.accelerator.api.deleteSession;


import org.apache.directory.api.ldap.model.message.AbstractExtendedRequest;


/**
 * RbacDeleteSessionRequest extended operation implementation.
 * 
 * It follows the ASN.1 description for this operation :
 * <pre>
 * RbacDeleteSessionRequest ::= SEQUENCE {
 *       userIdentity  [0] OCTET STRING,
 *       sessionId     [1] OCTET STRING,
 * }
 * </pre>
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class RbacDeleteSessionRequestImpl extends AbstractExtendedRequest implements RbacDeleteSessionRequest
{
    /** The session ID */
    private String sessionId;

    /** The user's identity */
    private String userIdentity;


    /**
     * Create a new instance of the RbacDeleteSessionRequestImpl extended operation
     */
    public RbacDeleteSessionRequestImpl()
    {
        setRequestName( EXTENSION_OID );
    }


    /**
     * Create a new instance of the RbacDeleteSessionRequestImpl extended operation
     * 
     * @param messageId The message ID
     */
    public RbacDeleteSessionRequestImpl( int messageId )
    {
        super( messageId );
        setRequestName( EXTENSION_OID );
    }


    /**
     * @return The session ID
     */
    public String getSessionId()
    {
        return sessionId;
    }


    /**
     * Sets the session ID
     * 
     * @param sessionID the session ID to set
     */
    public void setSessionId( String sessionID )
    {
        this.sessionId = sessionID;
    }


    /**
     * @return the userIdentity
     */
    public String getUserIdentity()
    {
        return userIdentity;
    }


    /**
     * @param userIdentity the userIdentity to set
     */
    public void setUserIdentity( String userIdentity )
    {
        this.userIdentity = userIdentity;
    }
    


    @Override
    public RbacDeleteSessionResponse getResultResponse()
    {
        if ( getResponse() == null )
        {
            setResponse( new RbacDeleteSessionResponseImpl() );
        }

        return null;
    }

    
    /**
     * @see Object#toString()
     */
    public String toString()
    {
        StringBuilder sb = new StringBuilder();

        sb.append( "RbacDeleteSessionRequest :" );
        sb.append( "\n    sessionId : " ).append( sessionId );
        sb.append( "\n    userIdentity : " ).append( userIdentity );
        
        return sb.toString();
    }
}
