/*
 * This work is part of OpenLDAP Software <http://www.openldap.org/>.
 *
 *  Copyright 1998-2014 The OpenLDAP Foundation.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted only as authorized by the OpenLDAP
 *  Public License.
 *
 *  A copy of this license is available in the file LICENSE in the
 *  top-level directory of the distribution or, alternatively, at
 *  <http://www.OpenLDAP.org/license.html>.
 */
package org.openldap.accelerator.api.deleteSession;


import org.apache.directory.api.ldap.model.message.ExtendedRequest;


/**
 * RbacDeleteSessionRequest extended operation interface.
 * 
 * It follows the ASN.1 description for this operation :
 * <pre>
 * RbacDeleteSessionRequest ::= SEQUENCE {
 *       userIdentity  [0] OCTET STRING,
 *       sessionId     [1] OCTET STRING,
 * }
 * </pre>
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public interface RbacDeleteSessionRequest extends ExtendedRequest
{
    /** The requestName for this extended request */
    static final String EXTENSION_OID = "1.3.6.1.4.1.4203.555.5";


    /**
     * @return the session ID
     */
    String getSessionId();


    /**
     * Sets the session ID
     * 
     * @param sessionID the session ID to set
     */
    void setSessionId( String sessionId );


    /**
     * @return the userIdentity
     */
    String getUserIdentity();


    /**
     * @param userIdentity the userIdentity to set
     */
    void setUserIdentity( String userIdentity );
}
