/*
 * This work is part of OpenLDAP Software <http://www.openldap.org/>.
 *
 *  Copyright 1998-2014 The OpenLDAP Foundation.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted only as authorized by the OpenLDAP
 *  Public License.
 *
 *  A copy of this license is available in the file LICENSE in the
 *  top-level directory of the distribution or, alternatively, at
 *  <http://www.OpenLDAP.org/license.html>.
 */
package org.openldap.accelerator.api.createSession;


import org.apache.directory.api.ldap.model.message.ExtendedResponse;


/**
 * RbacCreateSessionResponse extended operation interface.
 * 
 * It follows the ASN.1 description for this operation :
 * <pre>
 * RBACCreateSessionResponse ::= SEQUENCE {
 *       sessionId [0] OCTET STRING,
 * }
 * </pre>
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public interface RbacCreateSessionResponse extends ExtendedResponse
{
    /** The responseName for this extended response */
    static final String EXTENSION_OID = "1.3.6.1.4.1.4203.555.1";

    /**
     * @return The session ID
     */
    String getSessionId();


    /**
     * Sets the session ID
     * 
     * @param sessionId the session ID to set
     */
    void setSessionId( String sessionId );
}
