/*
 * This work is part of OpenLDAP Software <http://www.openldap.org/>.
 *
 *  Copyright 1998-2014 The OpenLDAP Foundation.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted only as authorized by the OpenLDAP
 *  Public License.
 *
 *  A copy of this license is available in the file LICENSE in the
 *  top-level directory of the distribution or, alternatively, at
 *  <http://www.OpenLDAP.org/license.html>.
 */
package org.openldap.accelerator.api.createSession;


import java.util.List;

import org.apache.directory.api.ldap.model.message.ExtendedRequest;


/**
 * RbacCreateSessionRequest extended operation interface.
 * 
 * It follows the ASN.1 description for this operation :
 * <pre>
 * RbacCreateSessionRequest ::= SEQUENCE {
 *       sessionId      [0] OCTET STRING OPTIONNAL,
 *       tenantId       [1] OCTET STRING OPTIONNAL,
 *       userIentity    [2] OCTET STRING OPTIONNAL,
 *       password       [3] OCTET STRING OPTIONNAL,
 *       roles          [4] Roles OPTIONNAL
 * }
 *   
 * Roles ::= SEQUENCE {
 *    role OCTET STRING OPTIONNAL
 * }
 * </pre>
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public interface RbacCreateSessionRequest extends ExtendedRequest
{
    /** The requestName for this extended request */
    static final String EXTENSION_OID = "1.3.6.1.4.1.4203.555.1";


    /**
     * @return The tenant ID
     */
    String getTenantId();


    /**
     * Sets the tenant ID
     * 
     * @param tenantId The tenant ID to set
     */
    void setTenantId( String tenantId );


    /**
     * Sets the session ID
     * 
     * @param sessionId the session ID to set
     */
    void setSessionId( String sessionId );


    /**
     * @return The session ID
     */
    String getSessionId();


    /**
     * @return the userIdentity
     */
    String getUserIdentity();


    /**
     * @param userIdentity the userIdentity to set
     */
    void setUserIdentity( String userIdentity );


    /**
     * @return the password
     */
    String getPassword();


    /**
     * @param password the password to set
     */
    void setPassword( String password );


    /**
     * @return the roles
     */
    List<String> getRoles();


    /**
     * @param roles the roles to set
     */
    void setRoles( List<String> roles );


    /**
     * @param role the role to add
     */
    void addRole( String role );
}
