/*
 * This work is part of OpenLDAP Software <http://www.openldap.org/>.
 *
 *  Copyright 1998-2014 The OpenLDAP Foundation.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted only as authorized by the OpenLDAP
 *  Public License.
 *
 *  A copy of this license is available in the file LICENSE in the
 *  top-level directory of the distribution or, alternatively, at
 *  <http://www.OpenLDAP.org/license.html>.
 */
package org.openldap.accelerator.api.checkAccess;


import org.apache.directory.api.ldap.model.message.ExtendedRequest;


/**
 * RbacCheckAccessRequest extended operation interface.
 * 
 * It follows the ASN.1 description for this operation :
 * <pre>
 * RbacCheckAccessRequest ::= SEQUENCE {
 *       sessionId     [0] OCTET STRING,
 *       operation     [1] OCTET STRING
 *       object        [2] OCTET STRING
 *       objectId      [3] OCTET STRING OPTIONAL
 * }
 * </pre>
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public interface RbacCheckAccessRequest extends ExtendedRequest
{
    /** The requestName for this extended request */
    static final String EXTENSION_OID = "1.3.6.1.4.1.4203.555.2";


    /**
     * @return the session ID
     */
    String getSessionId();


    /**
     * Sets the session ID
     * 
     * @param sessionId the session ID to set
     */
    void setSessionId( String sessionId );


    /**
     * @return the operation
     */
    String getOperation();


    /**
     * @param operation the operation to set
     */
    void setOperation( String operation );


    /**
     * @return the object
     */
    String getObject();


    /**
     * @param object the object to set.  This attribute is optional on the request.
     */
    void setObject( String object );

    /**
     * @return the objectId
     */
    public String getObjectId();


    /**
     * @param objectId the objectId to set.  This attribute is optional on the request.
     */
    public void setObjectId( String objectId );
}
