/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import org.openjdk.jol.info.GraphLayout;
import org.openjdk.jol.operations.ClasspathedOperation;

public class ObjectFootprint
extends ClasspathedOperation {
    @Override
    public String label() {
        return "footprint";
    }

    @Override
    public String description() {
        return "Estimate the footprint of all objects reachable from a given instance";
    }

    @Override
    public void runWith(Class<?> klass) throws Exception {
        try {
            Object o = this.tryInstantiate(klass);
            System.out.println(GraphLayout.parseInstance((Object)o).toFootprint());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Instantiation exception, does the class have the default constructor?", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Instantiation exception, does the class have the default constructor?", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Illegal access exception, does the class have the public default constructor?", e);
        }
    }
}

