/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openjdk.jol.Operation;
import org.openjdk.jol.operations.HeapDump;
import org.openjdk.jol.operations.ObjectEstimates;
import org.openjdk.jol.operations.ObjectExternals;
import org.openjdk.jol.operations.ObjectFootprint;
import org.openjdk.jol.operations.ObjectIdealPacking;
import org.openjdk.jol.operations.ObjectInternals;
import org.openjdk.jol.operations.StringCompress;

public class Main {
    private static SortedMap<String, Operation> operations = new TreeMap<String, Operation>();

    private static void registerOperation(Operation op) {
        operations.put(op.label(), op);
    }

    public static void main(String ... args) throws Exception {
        String mode = args.length >= 1 ? args[0] : "help";
        Operation op = (Operation)operations.get(mode);
        if (op != null) {
            String[] modeArgs = Arrays.copyOfRange(args, 1, args.length);
            op.run(modeArgs);
        } else if (!mode.equals("help")) {
            System.err.println("Unknown mode: " + mode);
            System.err.println();
            Main.printHelp(System.err);
            System.exit(1);
        } else {
            Main.printHelp(System.out);
            System.exit(0);
        }
    }

    private static void printHelp(PrintStream pw) {
        pw.println("Usage: jol-cli.jar <mode> [optional arguments]*");
        pw.println();
        pw.println("Available modes: ");
        for (Operation lop : operations.values()) {
            pw.printf("  %20s: %s%n", lop.label(), lop.description());
        }
    }

    static {
        Main.registerOperation(new ObjectInternals());
        Main.registerOperation(new ObjectExternals());
        Main.registerOperation(new ObjectEstimates());
        Main.registerOperation(new ObjectFootprint());
        Main.registerOperation(new ObjectIdealPacking());
        Main.registerOperation(new StringCompress());
        Main.registerOperation(new HeapDump());
    }
}

