/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openjdk.jol.Operation;
import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.datamodel.Model32;
import org.openjdk.jol.datamodel.Model64;
import org.openjdk.jol.datamodel.Model64_CCPS;
import org.openjdk.jol.datamodel.Model64_COOPS_CCPS;
import org.openjdk.jol.heap.HeapDumpException;
import org.openjdk.jol.heap.HeapDumpReader;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.FieldData;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.layouters.Layouter;
import org.openjdk.jol.util.Multiset;

public class StringCompress
implements Operation {
    static final String DO_MODE = System.getProperty("mode", "estimates");
    static final DataModel[] DATA_MODELS = new DataModel[]{new Model32(), new Model64(), new Model64_COOPS_CCPS(), new Model64_COOPS_CCPS(16), new Model64_CCPS(), new Model64_CCPS(16)};

    @Override
    public String label() {
        return "string-compress";
    }

    @Override
    public String description() {
        return "Consume the heap dumps and figures out the savings attainable with compressed strings.";
    }

    @Override
    public void run(String ... args) throws Exception {
        if (args.length == 0) {
            System.err.println("Expected one or more heap dump file names.");
            return;
        }
        if (DO_MODE.equalsIgnoreCase("histo")) {
            System.out.printf("%15s, %15s, %18s, %s%n", "\"size\"", "\"compressible\"", "\"non-compressible\"", "\"hprof file\"");
        } else if (DO_MODE.equalsIgnoreCase("estimates")) {
            System.out.printf("%15s, %15s, %15s, %15s, %15s, %15s, %15s, %15s, %15s, %s, %70s, %s%n", "\"total\"", "\"String\"", "\"String+bool\"", "\"String+oop\"", "\"char[]-2b\"", "\"char[]-1b\"", "\"char[]-1b-comp\"", "\"savings(same)\"", "\"savings(bool)\"", "\"savings(oop)\"", "\"model\"", "\"hprof file\"");
        }
        ArrayList<Future<Object>> res = new ArrayList<Future<Object>>();
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (String arg : args) {
            res.add(service.submit(new Worker(arg)));
        }
        for (Future future : res) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                e.getCause().printStackTrace(System.err);
            }
        }
        service.shutdown();
    }

    public static class Worker
    implements Callable<Object> {
        long stringID;
        int stringValueIdx;
        int stringValueSize;
        final Multiset<Integer> compressibleCharArrays;
        final Multiset<Integer> nonCompressibleCharArrays;
        final String path;

        public Worker(String arg) {
            this.path = arg;
            this.compressibleCharArrays = new Multiset();
            this.nonCompressibleCharArrays = new Multiset();
        }

        @Override
        public Object call() throws Exception {
            block6: {
                Multiset data;
                block5: {
                    final HashSet referencedArrays = new HashSet();
                    final HashMap isCompressible = new HashMap();
                    final HashMap size = new HashMap();
                    HeapDumpReader reader = new HeapDumpReader(new File(this.path)){

                        protected void visitClass(long id, String name, List<Integer> oopIdx, int oopSize) {
                            if (name.equals("java/lang/String")) {
                                Worker.this.stringID = id;
                                Worker.this.stringValueIdx = oopIdx.get(0);
                                Worker.this.stringValueSize = oopSize;
                            }
                        }

                        protected void visitInstance(long id, long klassID, byte[] bytes) {
                            if (Worker.this.stringID == 0L) {
                                throw new IllegalStateException("java/lang/String was not discovered yet in " + Worker.this.path);
                            }
                            if (klassID == Worker.this.stringID) {
                                long arrayId;
                                ByteBuffer wrap = ByteBuffer.wrap(bytes);
                                switch (Worker.this.stringValueSize) {
                                    case 4: {
                                        arrayId = wrap.getInt(Worker.this.stringValueIdx);
                                        break;
                                    }
                                    case 8: {
                                        arrayId = wrap.getLong(Worker.this.stringValueIdx);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalStateException();
                                    }
                                }
                                if (arrayId != 0L) {
                                    referencedArrays.add(arrayId);
                                }
                            }
                        }

                        protected void visitPrimArray(long id, String typeClass, int count, byte[] bytes) {
                            if (typeClass.equals("char")) {
                                isCompressible.put(id, Worker.isCompressible(bytes));
                                size.put(id, count);
                            }
                        }
                    };
                    data = reader.parse();
                    for (Long id : referencedArrays) {
                        Boolean compressible = (Boolean)isCompressible.get(id);
                        if (compressible == null) {
                            throw new HeapDumpException("String.value array " + id + " is not char[] in " + this.path + ", skipping");
                        }
                        if (compressible.booleanValue()) {
                            this.compressibleCharArrays.add(size.get(id));
                            continue;
                        }
                        this.nonCompressibleCharArrays.add(size.get(id));
                    }
                    if (!DO_MODE.equalsIgnoreCase("histo")) break block5;
                    TreeSet sizes = new TreeSet();
                    sizes.addAll(this.compressibleCharArrays.keys());
                    sizes.addAll(this.nonCompressibleCharArrays.keys());
                    for (Integer s : sizes) {
                        System.out.printf("%15d, %15d, %18d, \"%s\"%n", s, this.compressibleCharArrays.count((Object)s), this.nonCompressibleCharArrays.count((Object)s), this.path);
                    }
                    break block6;
                }
                if (!DO_MODE.equalsIgnoreCase("estimates")) break block6;
                for (DataModel model : DATA_MODELS) {
                    this.printLine((Multiset<ClassData>)data, (Layouter)new HotSpotLayouter(model, 8));
                }
            }
            return null;
        }

        private void printLine(Multiset<ClassData> data, Layouter l) {
            long strings = 0L;
            long stringsBool = 0L;
            long stringsOop = 0L;
            long totalFootprint = 0L;
            for (ClassData cd : data.keys()) {
                long count = data.count((Object)cd);
                if (cd.name().equals("java/lang/String")) {
                    ClassData mcd = ClassData.parseClass(Object.class);
                    mcd.addField(FieldData.create((String)"Object", (String)"value", (String)"char[]"));
                    mcd.addField(FieldData.create((String)"Object", (String)"hash", (String)"int"));
                    strings += l.layout(mcd).instanceSize() * count;
                    ClassData mcdBool = ClassData.parseClass(Object.class);
                    mcdBool.addField(FieldData.create((String)"Object", (String)"value", (String)"char[]"));
                    mcdBool.addField(FieldData.create((String)"Object", (String)"hash", (String)"int"));
                    mcdBool.addField(FieldData.create((String)"Object", (String)"isCompressed", (String)"boolean"));
                    stringsBool += l.layout(mcdBool).instanceSize() * count;
                    ClassData mcdOop = ClassData.parseClass(Object.class);
                    mcdOop.addField(FieldData.create((String)"Object", (String)"value", (String)"char[]"));
                    mcdOop.addField(FieldData.create((String)"Object", (String)"hash", (String)"int"));
                    mcdOop.addField(FieldData.create((String)"Object", (String)"coder", (String)"java/lang/Object"));
                    stringsOop += l.layout(mcdOop).instanceSize() * count;
                    continue;
                }
                totalFootprint += l.layout(cd).instanceSize() * count;
            }
            long compressedBytes = 0L;
            long compressibleBytes = 0L;
            for (Integer len : this.compressibleCharArrays.keys()) {
                long count = this.compressibleCharArrays.count((Object)len);
                ClassData charArr = new ClassData("char[]", "char", len.intValue());
                ClassData byteArr = new ClassData("byte[]", "byte", len.intValue());
                compressedBytes += l.layout(byteArr).instanceSize() * count;
                compressibleBytes += l.layout(charArr).instanceSize() * count;
            }
            long nonCompressibleBytes = 0L;
            for (Integer len : this.nonCompressibleCharArrays.keys()) {
                long count = this.nonCompressibleCharArrays.count((Object)len);
                ClassData charArr = new ClassData("char[]", "char", len.intValue());
                nonCompressibleBytes += l.layout(charArr).instanceSize() * count;
            }
            double savingSame = 100.0 * (double)(compressibleBytes - compressedBytes) / (double)(totalFootprint += strings);
            double savingBool = 100.0 * (double)(compressibleBytes - compressedBytes - (stringsBool - strings)) / (double)totalFootprint;
            double savingOop = 100.0 * (double)(compressibleBytes - compressedBytes - (stringsOop - strings)) / (double)totalFootprint;
            System.out.printf("%15d, %15d, %15d, %15d, %15d, %15d, %15d, %15.3f, %15.3f, %15.3f, %70s, \"%s\"%n", totalFootprint, strings, stringsBool, stringsOop, nonCompressibleBytes, compressibleBytes, compressedBytes, savingSame, savingBool, savingOop, "\"" + l + "\"", this.path);
        }

        public static boolean isCompressible(byte[] bytes) {
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            for (int c = 0; c < bytes.length; c += 2) {
                if ((buf.getShort(c) & 0xFF00) == 0) continue;
                return false;
            }
            return true;
        }
    }
}

