/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.bytecode;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.reflective.RFGeneratorSource;

class ClassInfoRepo {
    private final Map<String, ClassInfo> map = new HashMap<String, ClassInfo>();

    ClassInfoRepo() {
    }

    public ClassInfo get(String desc) {
        ClassInfo info = this.map.get(desc = desc.replace('/', '.'));
        if (info != null) {
            return info;
        }
        if (desc.equals(Boolean.TYPE.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(Boolean.TYPE);
        }
        if (desc.equals(Byte.TYPE.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(Byte.TYPE);
        }
        if (desc.equals(Character.TYPE.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(Character.TYPE);
        }
        if (desc.equals(Short.TYPE.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(Short.TYPE);
        }
        if (desc.equals(Integer.TYPE.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(Integer.TYPE);
        }
        if (desc.equals(Float.TYPE.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(Float.TYPE);
        }
        if (desc.equals(Long.TYPE.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(Long.TYPE);
        }
        if (desc.equals(Double.TYPE.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(Double.TYPE);
        }
        if (desc.equals(boolean[].class.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(boolean[].class);
        }
        if (desc.equals(byte[].class.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(byte[].class);
        }
        if (desc.equals(char[].class.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(char[].class);
        }
        if (desc.equals(short[].class.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(short[].class);
        }
        if (desc.equals(int[].class.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(int[].class);
        }
        if (desc.equals(float[].class.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(float[].class);
        }
        if (desc.equals(long[].class.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(long[].class);
        }
        if (desc.equals(double[].class.getCanonicalName())) {
            return RFGeneratorSource.resolveClass(double[].class);
        }
        if (desc.endsWith("[]")) {
            desc = "[L" + desc.substring(0, desc.length() - 2) + ";";
        }
        try {
            return RFGeneratorSource.resolveClass(Class.forName(desc, false, Thread.currentThread().getContextClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to resolve class: " + desc);
        }
    }

    public void put(String desc, ClassInfo info) {
        desc = desc.replace('/', '.');
        this.map.put(desc, info);
    }

    public Collection<ClassInfo> getInfos() {
        return this.map.values();
    }
}

