/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.RecordingPrinter;
import org.openjdk.jmc.flightrecorder.test.util.RecordingToolkit;
import org.openjdk.jmc.test.TestToolkit;
import org.openjdk.jmc.test.io.IOResource;
import org.openjdk.jmc.test.io.IOResourceSet;

public class PrintoutsToolkit {
    private static final Pattern EVENT_PATTERN = Pattern.compile("<event [\\s\\S]*?</event>");
    private static final String PRINTOUTS_DIRECTORY = "printouts";
    private static final String PRINTOUTS_INDEXFILE = "index.txt";
    private static final String UNIX_LINE_SEPARATOR = "\n";
    static final String LICENSE_HEADER;

    public static IOResourceSet[] getTestResources() throws IOException {
        IOResourceSet recordings = RecordingToolkit.getRecordings();
        IOResourceSet printouts = PrintoutsToolkit.getPrintouts();
        if (recordings.getResources().size() != printouts.getResources().size()) {
            throw new RuntimeException("The number of printouts does not match the number of recording files.");
        }
        ArrayList<IOResourceSet> list = new ArrayList<IOResourceSet>();
        for (IOResource recordinfile : recordings) {
            IOResource printoutFile = printouts.findWithPrefix(recordinfile.getName());
            if (printoutFile == null) {
                throw new RuntimeException("Could not find printout file for " + String.valueOf(recordinfile));
            }
            list.add(new IOResourceSet(recordinfile, printoutFile));
        }
        return list.toArray(new IOResourceSet[list.size()]);
    }

    public static File getPrintoutDirectory() throws IOException {
        return TestToolkit.getProjectDirectory(PrintoutsToolkit.class, PRINTOUTS_DIRECTORY);
    }

    private static IOResourceSet getPrintouts() throws IOException {
        return TestToolkit.getResourcesInDirectory(PrintoutsToolkit.class, PRINTOUTS_DIRECTORY, PRINTOUTS_INDEXFILE);
    }

    public static void printRecording(File sourceFile, File destinationFile) throws IOException, CouldNotLoadRecordingException {
        try (FileOutputStream output = new FileOutputStream(destinationFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, "UTF-8");){
            ((Writer)writer).append(LICENSE_HEADER);
            IItemCollection events = JfrLoaderToolkit.loadEvents((File)sourceFile);
            for (String e : PrintoutsToolkit.getEventsAsStrings(events)) {
                ((Writer)writer).append(e).append('\n');
            }
        }
    }

    public static List<String> getEventsAsStrings(IItemCollection items) throws IOException {
        ArrayList<String> events = new ArrayList<String>();
        Iterator itemIterable = items.iterator();
        while (itemIterable.hasNext()) {
            for (IItem item : (IItemIterable)itemIterable.next()) {
                StringWriter writer = new StringWriter();
                PrintWriter unixNewlineWriter = new PrintWriter(writer){

                    @Override
                    public void println() {
                        this.print(PrintoutsToolkit.UNIX_LINE_SEPARATOR);
                    }
                };
                RecordingPrinter printer = new RecordingPrinter(unixNewlineWriter, RecordingPrinter.Verbosity.HIGH, false);
                printer.printEvent(item);
                events.add(writer.toString());
            }
        }
        events.sort(null);
        return events;
    }

    public static List<String> getEventsFromPrintout(IOResourceSet resourceSet) throws IOException, Exception {
        ArrayList<String> events = new ArrayList<String>();
        try (InputStream is = resourceSet.getResource(1).open();){
            String baseline = StringToolkit.readString((InputStream)is, (String)"UTF-8");
            baseline = PrintoutsToolkit.stripHeader(baseline);
            try (Scanner scanner = new Scanner(baseline);){
                String eventAsText = scanner.findWithinHorizon(EVENT_PATTERN, 0);
                while (eventAsText != null) {
                    events.add(eventAsText);
                    eventAsText = scanner.findWithinHorizon(EVENT_PATTERN, 0);
                }
            }
        }
        return events;
    }

    public static void main(String[] args) throws IOException, CouldNotLoadRecordingException {
        PrintoutsToolkit.printRecording(new File(args[0]), new File(args[1]));
    }

    static String stripHeader(String baseline) throws Exception {
        if (!(baseline = baseline.replaceAll("\\r\\n", UNIX_LINE_SEPARATOR)).startsWith(LICENSE_HEADER)) {
            throw new Exception("No license header in baseline!");
        }
        return baseline.substring(LICENSE_HEADER.length());
    }

    static {
        String header = null;
        try {
            header = StringToolkit.readString((InputStream)PrintoutsToolkit.class.getClassLoader().getResourceAsStream("license/license.txt"), (String)"UTF-8");
            header = header.replaceAll("\\r\\n", UNIX_LINE_SEPARATOR);
        }
        catch (IOException e) {
            throw new RuntimeException("License header not found!");
        }
        LICENSE_HEADER = header;
    }
}

