/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.test;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.junit.Assert;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.test.io.IOResource;
import org.openjdk.jmc.test.io.IOResourceSet;
import org.openjdk.jmc.test.io.ResourceResource;

public final class TestToolkit {
    private TestToolkit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOResourceSet getResourcesInDirectory(Class<?> clazz, String directory, String indexFile) throws IOException {
        InputStream in = null;
        BufferedReader br = null;
        ArrayList<IOResource> resources = new ArrayList<IOResource>();
        try {
            String filename;
            in = clazz.getClassLoader().getResourceAsStream(directory + "/" + indexFile);
            br = new BufferedReader(new InputStreamReader(in));
            while ((filename = br.readLine()) != null) {
                if ((filename = filename.trim()).isEmpty() || filename.startsWith("#")) continue;
                resources.add(new ResourceResource(clazz, directory, filename));
            }
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(in);
            IOToolkit.closeSilently(br);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)in);
        IOToolkit.closeSilently((Closeable)br);
        return new IOResourceSet(resources);
    }

    public static IOResource getNamedResource(Class<?> clazz, String directory, String fileName) throws IOException {
        String resourceName = directory + "/" + fileName;
        if (clazz.getClassLoader().getResource(resourceName) == null) {
            throw new IOException("Resource not found: " + resourceName);
        }
        return new ResourceResource(clazz, directory, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertEquals(IOResource expected, IOResource actual) throws IOException {
        BufferedReader readerExp = null;
        BufferedReader readerAct = null;
        try {
            readerExp = new BufferedReader(new InputStreamReader(expected.open(), StandardCharsets.UTF_8));
            readerAct = new BufferedReader(new InputStreamReader(actual.open(), StandardCharsets.UTF_8));
            int lineNumber = 0;
            String expLine = null;
            while ((expLine = readerExp.readLine()) != null) {
                String actLine = readerAct.readLine();
                if (actLine == null) {
                    Assert.fail((String)("Premature end of file " + actual));
                }
                Assert.assertEquals((String)("Actual result file " + actual + " differs from expected file " + expected + " at line " + (lineNumber + 1)), (Object)expLine, (Object)actLine);
                ++lineNumber;
            }
            if (readerAct.readLine() != null) {
                Assert.fail((String)("Premature end of file " + expected));
            }
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(readerExp);
            IOToolkit.closeSilently(readerAct);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)readerExp);
        IOToolkit.closeSilently((Closeable)readerAct);
    }

    public static File getProjectDirectory(Class<?> clazz, String directoryName) throws IOException {
        URL url = TestToolkit.getLocation(clazz);
        File file = TestToolkit.findParentDirectory(TestToolkit.createFile(url), "org.openjdk.jmc");
        if (file != null) {
            return new File(file, directoryName);
        }
        throw new IOException("Could not find project directory " + url);
    }

    private static URL getLocation(Class<?> clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation();
    }

    private static File createFile(URL url) throws IOException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid filename " + url);
        }
    }

    private static File findParentDirectory(File startDirectory, String directory) {
        for (File file = startDirectory; file != null; file = file.getParentFile()) {
            if (!file.getName().startsWith(directory)) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void materialize(Class<?> clazz, String directoryName, String fileName, File directory) throws IOException {
        block8: {
            if (fileName == null) {
                throw new IOException("Must specify file name to materialize");
            }
            if (!directory.delete()) {
                throw new IOException("Could not delete directory: " + directory.getAbsolutePath());
            }
            if (!directory.mkdirs()) {
                throw new IOException("Could not create directory: " + directory.getAbsolutePath());
            }
            ResourceResource rr = new ResourceResource(clazz, directoryName, fileName);
            InputStream in = null;
            try {
                in = rr.open();
                if (in == null) break block8;
                FileOutputStream os = null;
                try {
                    File file = new File(directory, fileName);
                    os = new FileOutputStream(file);
                    IOToolkit.copy((InputStream)in, (OutputStream)os);
                    os.close();
                }
                catch (Throwable throwable) {
                    IOToolkit.closeSilently(os);
                    throw throwable;
                }
                IOToolkit.closeSilently((Closeable)os);
            }
            finally {
                IOToolkit.closeSilently((Closeable)in);
            }
        }
    }

    public static File materialize(Class<?> clazz, String directoryName, String fileName) throws IOException {
        File directory = File.createTempFile(directoryName, ".dir");
        TestToolkit.materialize(clazz, directoryName, fileName, directory);
        return directory;
    }
}

