/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.util;

import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;

public class MockStacktraceGenerator {
    public static IMCStackTrace[] generateTraces(boolean truncated, boolean recursive, int extraFrames, FrameSeparator.FrameCategorization frameCategorization, boolean differentFrameType) {
        ArrayList<MockStackTrace> traces = new ArrayList<MockStackTrace>();
        MockType type = new MockType("org.openjdk.jmc", "MockType");
        MockType typeDifferentPackage = new MockType("org.openjdk.jmc2", "MockType");
        MockType typeDifferentClass = new MockType("org.openjdk.jmc", "MockType2");
        MockMethod method = new MockMethod(type, "foobar", "()V", 0, Boolean.FALSE);
        MockMethod methodDifferentPackage = new MockMethod(typeDifferentPackage, "foobar", "()V", 0, Boolean.FALSE);
        MockMethod methodDifferentClass = new MockMethod(typeDifferentClass, "foobar", "()V", 0, Boolean.FALSE);
        MockFrame frame = new MockFrame(method, 1, 1, IMCFrame.Type.JIT_COMPILED);
        MockFrame frameDifferentBCI = new MockFrame(method, 2, 1, IMCFrame.Type.JIT_COMPILED);
        MockFrame frameDifferentLine = new MockFrame(method, 1, 2, IMCFrame.Type.JIT_COMPILED);
        MockFrame frameDifferentClass = new MockFrame(methodDifferentClass, 1, 1, IMCFrame.Type.JIT_COMPILED);
        MockFrame frameDifferentPackage = new MockFrame(methodDifferentPackage, 1, 1, IMCFrame.Type.JIT_COMPILED);
        MockFrame frameDifferentFrameType = new MockFrame(method, 1, 1, IMCFrame.Type.INTERPRETED);
        ArrayList<IMCFrame> frames = new ArrayList<IMCFrame>();
        frames.add(frame);
        if (recursive) {
            frames.add(frame);
        }
        MockStackTrace trace = new MockStackTrace(frames, truncated ? IMCStackTrace.TruncationState.TRUNCATED : IMCStackTrace.TruncationState.NOT_TRUNCATED);
        traces.add(trace);
        if (extraFrames > 0) {
            for (int i = 0; i < extraFrames; ++i) {
                MockMethod extraMethod = new MockMethod(type, "foobar" + i, "()V", 0, Boolean.FALSE);
                MockFrame extraFrame = new MockFrame(extraMethod, 1, 1, IMCFrame.Type.JIT_COMPILED);
                frames.add(extraFrame);
            }
        }
        if (frameCategorization != null || differentFrameType) {
            ArrayList<IMCFrame> frames2 = new ArrayList<IMCFrame>();
            if (frameCategorization != null) {
                switch (frameCategorization) {
                    case BCI: {
                        frames2.add(frameDifferentBCI);
                        break;
                    }
                    case LINE: {
                        frames2.add(frameDifferentLine);
                        break;
                    }
                    case CLASS: {
                        frames2.add(frameDifferentClass);
                        break;
                    }
                    case PACKAGE: {
                        frames2.add(frameDifferentPackage);
                        break;
                    }
                    default: {
                        frames2.add(frame);
                        break;
                    }
                }
            } else if (differentFrameType) {
                frames2.add(frameDifferentFrameType);
                frames2.add(frame);
            }
            frames2.add(frame);
            MockStackTrace trace2 = new MockStackTrace(frames2, truncated ? IMCStackTrace.TruncationState.TRUNCATED : IMCStackTrace.TruncationState.NOT_TRUNCATED);
            traces.add(trace2);
        }
        return traces.toArray(new IMCStackTrace[traces.size()]);
    }

    private static class MockType
    implements IMCType {
        private String packageName;
        private String typeName;

        public MockType(String packageName, String typeName) {
            this.packageName = packageName;
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getFullName() {
            return this.packageName != null && !this.packageName.isEmpty() ? this.packageName + "." + this.typeName : this.typeName;
        }

        public IMCPackage getPackage() {
            return null;
        }
    }

    private static class MockMethod
    implements IMCMethod {
        private IMCType type;
        private String methodName;
        private String formalDescriptor;
        private Integer modifier;
        private Boolean isNative;

        public MockMethod(IMCType type, String methodName, String formalDescriptor, Integer modifier, Boolean isNative) {
            this.type = type;
            this.methodName = methodName;
            this.formalDescriptor = formalDescriptor;
            this.modifier = modifier;
            this.isNative = isNative;
        }

        public IMCType getType() {
            return this.type;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getFormalDescriptor() {
            return this.formalDescriptor;
        }

        public Integer getModifier() {
            return this.modifier;
        }

        public Boolean isNative() {
            return this.isNative;
        }

        public Boolean isHidden() {
            return null;
        }
    }

    private static class MockFrame
    implements IMCFrame {
        private IMCMethod method;
        private Integer bci;
        private Integer frameLineNumber;
        private IMCFrame.Type type;

        public MockFrame(IMCMethod method, Integer bci, Integer frameLineNumber, IMCFrame.Type type) {
            this.method = method;
            this.bci = bci;
            this.frameLineNumber = frameLineNumber;
            this.type = type;
        }

        public Integer getFrameLineNumber() {
            return this.frameLineNumber;
        }

        public Integer getBCI() {
            return this.bci;
        }

        public IMCMethod getMethod() {
            return this.method;
        }

        public IMCFrame.Type getType() {
            return this.type;
        }

        public String toString() {
            return this.method.getMethodName() + ":" + this.frameLineNumber + "[" + this.bci + "]";
        }
    }

    private static class MockStackTrace
    implements IMCStackTrace {
        private List<IMCFrame> frames;
        private IMCStackTrace.TruncationState truncationState;

        public MockStackTrace(List<IMCFrame> frames, IMCStackTrace.TruncationState truncationState) {
            this.frames = frames;
            this.truncationState = truncationState;
        }

        public List<? extends IMCFrame> getFrames() {
            return this.frames;
        }

        public IMCStackTrace.TruncationState getTruncationState() {
            return this.truncationState;
        }
    }
}

