/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.codegen.radixtree;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.libj.lang.Identifiers;
import org.libj.lang.Strings;
import org.openjax.codegen.radixtree.RadixTreeEnumUtil;

public final class RadixTreeEnumGenerator {
    private static final Pattern whitespacePattern = Pattern.compile("\\s+");
    private final String pkg;
    private final String enumName;
    private final String inheritsFrom;
    private final Word[] words;
    protected final int[] root;

    public static void generate(String className, File outFile, Reader reader) throws IOException {
        RadixTreeEnumGenerator.generate(className, null, outFile, reader);
    }

    public static void generate(String className, String inheritsFrom, File outFile, Reader reader) throws IOException {
        int ch;
        File parentFile = outFile.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IllegalStateException("Unable to create output path: " + parentFile.getAbsolutePath());
        }
        StringBuilder builder = new StringBuilder();
        while ((ch = reader.read()) != -1) {
            builder.append((char)ch);
        }
        String in = whitespacePattern.matcher(builder.toString()).replaceAll(" ");
        String[] tokens = Strings.split((CharSequence)in, (char)' ');
        RadixTreeEnumGenerator.generate(className, inheritsFrom, outFile, tokens);
    }

    public static void generate(String className, File outFile, String[] tokens) throws IOException {
        RadixTreeEnumGenerator.generate(className, null, outFile, tokens);
    }

    public static void generate(String className, String inheritsFrom, File outFile, String[] tokens) throws IOException {
        RadixTreeEnumGenerator generator = new RadixTreeEnumGenerator(className, inheritsFrom, tokens);
        generator.print(outFile);
    }

    private RadixTreeEnumGenerator(String className, String inheritsFrom, String[] tokens) {
        int i;
        int lastDot = className.lastIndexOf(46);
        this.pkg = lastDot == -1 ? null : className.substring(0, lastDot);
        this.enumName = lastDot == -1 ? className : className.substring(lastDot + 1);
        this.inheritsFrom = inheritsFrom;
        this.words = new Word[tokens.length];
        Arrays.sort(tokens);
        int i$ = tokens.length;
        for (i = 0; i < i$; ++i) {
            this.words[i] = new Word(tokens[i]);
        }
        this.root = new int[tokens.length];
        i$ = this.root.length;
        for (i = 0; i < i$; ++i) {
            this.root[i] = i;
        }
        this.init(this.root, 0);
    }

    protected void init(int[] keywords, int depth) {
        this.traverse(keywords, depth);
        for (int keyword : keywords) {
            int[][] tree = this.words[keyword].tree;
            if (tree[depth] == null) continue;
            this.init(tree[depth], depth + 1);
        }
    }

    private void traverse(int[] keywords, int depth) {
        String name;
        int[] indices;
        if (keywords.length <= 1) {
            return;
        }
        for (int l = 0; l < keywords.length && (indices = this.recurse(keywords, l, depth < (name = this.words[keywords[l]].name).length() ? name.charAt(depth) : (char)'\u0000', depth, 0)) != null; l += indices.length) {
            for (int index : indices) {
                ((Word)this.words[index]).tree[depth] = indices;
            }
        }
    }

    private int[] recurse(int[] keywords, int index, char ch, int depth, int size) {
        String name = this.words[keywords[index]].name;
        if (name.length() <= depth || ch != name.charAt(depth)) {
            return 0 < size ? new int[size] : null;
        }
        int[] array = index + 1 < keywords.length ? this.recurse(keywords, index + 1, ch, depth, size + 1) : new int[size + 1];
        array[size] = keywords[index];
        return array;
    }

    public void print(File file) throws IOException {
        StringBuilder outer = new StringBuilder();
        StringBuilder x = null;
        StringBuilder y = null;
        for (Word word : this.words) {
            if (x == null) {
                x = new StringBuilder();
            } else {
                x.setLength(0);
            }
            int i$ = word.tree.length;
            for (int i = 0; i < i$; ++i) {
                if (y == null) {
                    y = new StringBuilder();
                } else {
                    y.setLength(0);
                }
                if (word.tree[i] != null) {
                    int j$ = word.tree[i].length;
                    for (int j = 0; j < j$; ++j) {
                        y.append(", ").append(word.tree[i][j]);
                    }
                }
                if (y.length() < 2) continue;
                x.append(", {").append(y.substring(2)).append('}');
            }
            outer.append(",\n  ").append(word.toString().toUpperCase()).append("(\"").append(word.name).append("\", new int[][] {").append(x.substring(2)).append("})");
        }
        StringBuilder code = new StringBuilder();
        if (this.pkg != null) {
            code.append("package ").append(this.pkg).append(";\n\n");
        }
        code.append("public enum ").append(this.enumName);
        code.append(this.inheritsFrom != null ? " implements " + this.inheritsFrom + " {\n" : " {\n");
        code.append(outer.substring(2)).append(";\n\n");
        code.append("  private static final int[] root = {");
        StringBuilder root = new StringBuilder();
        int i$ = this.words.length;
        for (int i = 0; i < i$; ++i) {
            root.append(", ").append(i);
        }
        code.append(root.substring(2)).append("};\n");
        code.append("  private static final ").append(this.enumName).append("[] values = values();\n");
        code.append("  private final ").append(String.class.getName()).append(" token;\n");
        code.append("  final int[][] tree;\n\n");
        code.append("  ").append(this.enumName).append("(final ").append(String.class.getName()).append(" token, final int[][] tree) {\n");
        code.append("    this.token = token;\n");
        code.append("    this.tree = tree;\n");
        code.append("  }\n\n");
        code.append("  public static ").append(this.enumName).append(" findNext(final ").append(this.enumName).append(" previous, final int position, final char ch) {\n");
        code.append("    if (position == 0) {\n");
        code.append("      final int index = ").append(RadixTreeEnumUtil.class.getName()).append(".binarySearch(values, ").append(this.enumName).append(".root, ch, position);\n");
        code.append("      return index < 0 ? null : values[index];\n");
        code.append("    }\n\n");
        code.append("    if (position <= previous.tree.length) {\n");
        code.append("      final int[] tree = previous.tree[position - 1];\n");
        code.append("      final int index = ").append(RadixTreeEnumUtil.class.getName()).append(".binarySearch(values, tree, ch, position);\n");
        code.append("      return index < 0 ? null : values[tree[index]];\n");
        code.append("    }\n\n");
        code.append("    return previous.token.length() <= position || previous.token.charAt(position) != ch ? null : previous;\n");
        code.append("  }\n\n");
        code.append("  @").append(Override.class.getName()).append('\n');
        code.append("  public ").append(String.class.getName()).append(" toString() {\n");
        code.append("    return token;\n");
        code.append("  }\n");
        code.append('}');
        Files.write(file.toPath(), code.toString().getBytes(), new OpenOption[0]);
    }

    private static final class Word {
        private final String name;
        private final String identifier;
        private final int[][] tree;

        private Word(String name) {
            this.name = name;
            this.identifier = Identifiers.toIdentifier((String)name.toUpperCase(), (char)'_', (char)'$');
            this.tree = new int[name.length() + 1][];
        }

        public String toString() {
            return this.identifier;
        }
    }
}

