/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processing.timefinder;

import java.util.List;
import org.openimaj.image.Image;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.video.Video;
import org.openimaj.video.VideoCache;
import org.openimaj.video.processing.tracking.ObjectTracker;
import org.openimaj.video.timecode.HrsMinSecFrameTimecode;
import org.openimaj.video.timecode.VideoTimecode;

public class ObjectTimeFinder {
    public <I extends Image<?, I>, O> IndependentPair<VideoTimecode, VideoTimecode> trackObject(ObjectTracker<O, I> objectTracker, Video<I> video, VideoTimecode keyframeTime, Rectangle bounds, TimeFinderListener<O, I> listener) {
        HrsMinSecFrameTimecode startTime = new HrsMinSecFrameTimecode(keyframeTime.getFrameNumber(), video.getFPS());
        HrsMinSecFrameTimecode endTime = new HrsMinSecFrameTimecode(keyframeTime.getFrameNumber(), video.getFPS());
        video.setCurrentFrameIndex(startTime.getFrameNumber());
        Image image = video.getCurrentFrame();
        Image keyframeImage = image.clone();
        objectTracker.initialiseTracking(bounds, image);
        boolean foundObject = true;
        while (foundObject && image != null) {
            List<O> objects = objectTracker.trackObject(image);
            if (objects.size() == 0) {
                foundObject = false;
                continue;
            }
            image = video.getNextFrame();
            endTime.setFrameNumber((long)video.getCurrentFrameIndex());
            if (listener == null) continue;
            listener.objectTracked(objects, (VideoTimecode)endTime, image);
        }
        objectTracker.initialiseTracking(bounds, keyframeImage);
        foundObject = true;
        int nFramesToJumpBack = (int)video.getFPS() * 2;
        HrsMinSecFrameTimecode currentTimecode = new HrsMinSecFrameTimecode(Math.max(startTime.getFrameNumber() - (long)nFramesToJumpBack, 0L), video.getFPS());
        while (foundObject && currentTimecode.getFrameNumber() >= 0L) {
            VideoCache vc = VideoCache.cacheVideo(video, (VideoTimecode)currentTimecode, (VideoTimecode)startTime);
            for (int n = 1; n <= vc.getNumberOfFrames(); ++n) {
                image = vc.getFrame(vc.getNumberOfFrames() - n);
                List<O> objects = objectTracker.trackObject(image);
                if (objects.size() == 0) {
                    foundObject = false;
                    break;
                }
                startTime.setFrameNumber(startTime.getFrameNumber() - 1L);
                if (listener == null) continue;
                listener.objectTracked(objects, (VideoTimecode)startTime, image);
            }
            if (currentTimecode.getFrameNumber() == 0L) {
                foundObject = false;
            }
            currentTimecode.setFrameNumber(Math.max(startTime.getFrameNumber() - (long)nFramesToJumpBack, 0L));
        }
        return new IndependentPair((Object)startTime, (Object)endTime);
    }

    public static interface TimeFinderListener<O, I> {
        public void objectTracked(List<O> var1, VideoTimecode var2, I var3);
    }
}

