/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processing.motion;

import java.util.HashMap;
import java.util.Map;
import org.openimaj.image.FImage;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.video.Video;
import org.openimaj.video.VideoFrame;
import org.openimaj.video.VideoSubFrame;
import org.openimaj.video.processing.motion.MotionEstimator;
import org.openimaj.video.processing.motion.MotionEstimatorAlgorithm;

public class GridMotionEstimator
extends MotionEstimator {
    private int x;
    private int y;
    private boolean fixed;

    public GridMotionEstimator(MotionEstimatorAlgorithm alg, int x, int y, boolean fixed) {
        super(alg);
        this.x = x;
        this.y = y;
        this.fixed = fixed;
    }

    public GridMotionEstimator(Video<FImage> v, MotionEstimatorAlgorithm alg, int x, int y, boolean fixed) {
        super(v, alg);
        this.x = x;
        this.y = y;
        this.fixed = fixed;
    }

    @Override
    protected Map<Point2d, Point2d> estimateMotionField(MotionEstimatorAlgorithm estimator, VideoFrame<FImage> vf, VideoFrame<FImage>[] array) {
        if (array.length < 1) {
            return new HashMap<Point2d, Point2d>();
        }
        int gw = 0;
        int gh = 0;
        if (this.fixed) {
            gw = this.x;
            gh = this.y;
        } else {
            gw = ((FImage)vf.frame).getWidth() / this.x;
            gh = ((FImage)vf.frame).getHeight() / this.y;
        }
        HashMap<Point2d, Point2d> out = new HashMap<Point2d, Point2d>();
        VideoSubFrame[] otherFrames = new VideoSubFrame[array.length];
        for (int yy = 0; yy < ((FImage)vf.frame).getHeight(); yy += gh) {
            for (int xx = 0; xx < ((FImage)vf.frame).getWidth(); xx += gw) {
                for (int ff = 0; ff < array.length; ++ff) {
                    otherFrames[ff] = new VideoSubFrame(array[ff].frame, array[ff].timecode, new Rectangle((float)xx, (float)yy, (float)gw, (float)gh));
                }
                out.put((Point2d)new Point2dImpl((float)xx + (float)gw / 2.0f, (float)yy + (float)gh / 2.0f), estimator.estimateMotion((VideoSubFrame<FImage>)new VideoSubFrame(vf.frame, vf.timecode, new Rectangle((float)xx, (float)yy, (float)gw, (float)gh)), otherFrames));
            }
        }
        return out;
    }
}

