/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processing.effects;

import java.util.LinkedList;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processing.convolution.FImageConvolveSeparable;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.video.Video;
import org.openimaj.video.processor.VideoProcessor;

public class GreyscaleSlitScanProcessor
extends VideoProcessor<MBFImage> {
    private final LinkedList<MBFImage> cache = new LinkedList();
    private final float[] blurKern = FGaussianConvolve.makeKernel((float)0.5f);
    private int cacheSize = 240;
    private FImage timemapImage = null;
    private boolean needToFixTimemap = true;

    public GreyscaleSlitScanProcessor(FImage timemap) {
        this(timemap, 240);
    }

    public GreyscaleSlitScanProcessor(FImage timemap, int cacheSize) {
        this.cacheSize = cacheSize;
        this.timemapImage = timemap;
    }

    public GreyscaleSlitScanProcessor(Video<MBFImage> video, FImage timemap, int cacheSize) {
        super(video);
        this.cacheSize = cacheSize;
        this.timemapImage = timemap;
    }

    public GreyscaleSlitScanProcessor(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public GreyscaleSlitScanProcessor(Video<MBFImage> video, int cacheSize) {
        super(video);
        this.cacheSize = cacheSize;
    }

    public MBFImage processFrame(MBFImage frame) {
        this.addToCache(frame);
        if (this.timemapImage == null || this.timemapImage.getWidth() != frame.getWidth() || this.timemapImage.getHeight() != frame.getHeight()) {
            this.needToFixTimemap = true;
        }
        if (this.needToFixTimemap) {
            this.fixTimemapImage(frame.getWidth(), frame.getHeight());
        }
        int height = frame.getHeight();
        int width = frame.getWidth();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int index = (int)this.timemapImage.pixels[y][x];
                if (index >= this.cache.size()) {
                    index = this.cache.size() - 1;
                }
                MBFImage cacheImage = this.cache.get(index);
                frame.setPixel(x, y, cacheImage.getPixel(x, y));
            }
        }
        for (FImage f : frame.bands) {
            FImageConvolveSeparable.convolveVertical((FImage)f, (float[])this.blurKern);
        }
        if (this.cache.size() >= this.cacheSize) {
            this.cache.removeLast();
        }
        return frame;
    }

    private void fixTimemapImage(int width, int height) {
        this.timemapImage = ResizeProcessor.resample((FImage)this.timemapImage, (int)width, (int)height);
        for (int y = 0; y < this.timemapImage.getHeight(); ++y) {
            for (int x = 0; x < this.timemapImage.getWidth(); ++x) {
                this.timemapImage.pixels[y][x] = (float)Math.floor(this.timemapImage.pixels[y][x] * (float)this.cacheSize);
            }
        }
        this.needToFixTimemap = false;
    }

    private void addToCache(MBFImage frame) {
        MBFImage f = (MBFImage)frame.clone();
        this.cache.addFirst(f);
    }
}

