/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection.hog;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.openimaj.data.dataset.VFSListDataset;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.objectdetection.hog.HOGClassifier;
import org.openimaj.image.objectdetection.hog.HOGDetector;
import org.openimaj.io.IOUtils;
import org.openimaj.math.geometry.shape.Rectangle;

public class Evaluate {
    public static void main(String[] args) throws IOException {
        HOGClassifier classifier = (HOGClassifier)IOUtils.readFromFile((File)new File("initial-classifier.dat"));
        HOGDetector detector = new HOGDetector(classifier);
        float thresh = 0.0f;
        while (thresh < 1.0f) {
            detector.threshold = thresh;
            VFSListDataset neg = new VFSListDataset("/Users/jsh2/Data/INRIAPerson/Test/neg", ImageUtilities.FIMAGE_READER);
            VFSListDataset pos = new VFSListDataset("/Users/jsh2/Data/INRIAPerson/Test/pos", ImageUtilities.FIMAGE_READER);
            int falsePositives = 0;
            int trueNegatives = 0;
            for (FImage i : neg) {
                List<Rectangle> rectangles = detector.detect(i);
                if (rectangles.size() > 0) {
                    ++falsePositives;
                    continue;
                }
                ++trueNegatives;
            }
            int falseNegatives = 0;
            int truePositives = 0;
            for (FImage i : pos) {
                List<Rectangle> rectangles = detector.detect(i);
                if (rectangles.size() > 0) {
                    ++truePositives;
                    continue;
                }
                ++falseNegatives;
            }
            double missRate = (double)falseNegatives / (double)(truePositives + falseNegatives);
            System.out.format("%f\t%d\t%d\t%d\t%d\t%f\n", Float.valueOf(thresh), truePositives, trueNegatives, falsePositives, falseNegatives, missRate);
            thresh = (float)((double)thresh + 0.1);
        }
    }
}

