/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection.haar;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.SummedSqTiltAreaTable;
import org.openimaj.image.objectdetection.AbstractMultiScaleObjectDetector;
import org.openimaj.image.objectdetection.haar.StageTreeClassifier;
import org.openimaj.math.geometry.shape.Rectangle;

@Reference(type=ReferenceType.Inproceedings, author={"Viola, P.", "Jones, M."}, title="Rapid object detection using a boosted cascade of simple features", year="2001", booktitle="Computer Vision and Pattern Recognition, 2001. CVPR 2001. Proceedings of the 2001 IEEE Computer Society Conference on", pages={" I", "511 ", " I", "518 vol.1"}, number="", volume="1", customData={"keywords", " AdaBoost; background regions; boosted simple feature cascade; classifiers; face detection; image processing; image representation; integral image; machine learning; object specific focus-of-attention mechanism; rapid object detection; real-time applications; statistical guarantees; visual object detection; feature extraction; image classification; image representation; learning (artificial intelligence); object detection;", "doi", "10.1109/CVPR.2001.990517", "ISSN", "1063-6919 "})
public class Detector
extends AbstractMultiScaleObjectDetector<FImage, Rectangle> {
    public static final int DEFAULT_SMALL_STEP = 1;
    public static final int DEFAULT_BIG_STEP = 2;
    public static final float DEFAULT_SCALE_FACTOR = 1.1f;
    protected StageTreeClassifier cascade;
    protected float scaleFactor = 1.1f;
    protected int smallStep = 1;
    protected int bigStep = 2;

    public Detector(StageTreeClassifier cascade, float scaleFactor, int smallStep, int bigStep) {
        super(Math.max(cascade.width, cascade.height), 0);
        this.cascade = cascade;
        this.scaleFactor = scaleFactor;
        this.smallStep = smallStep;
        this.bigStep = bigStep;
    }

    public Detector(StageTreeClassifier cascade, float scaleFactor) {
        this(cascade, scaleFactor, 1, 2);
    }

    public Detector(StageTreeClassifier cascade) {
        this(cascade, 1.1f, 1, 2);
    }

    protected void detectAtScale(SummedSqTiltAreaTable sat, int startX, int stopX, int startY, int stopY, float ystep, int windowWidth, int windowHeight, List<Rectangle> results) {
        for (int iy = startY; iy < stopY; ++iy) {
            int y = Math.round((float)iy * ystep);
            int xstep = 0;
            for (int ix = startX; ix < stopX; ix += xstep) {
                int x = Math.round((float)ix * ystep);
                int result = this.cascade.classify(sat, x, y);
                if (result > 0) {
                    results.add(new Rectangle((float)x, (float)y, (float)windowWidth, (float)windowHeight));
                }
                xstep = result > 0 ? this.smallStep : this.bigStep;
            }
        }
    }

    @Override
    public List<Rectangle> detect(FImage image) {
        ArrayList<Rectangle> results = new ArrayList<Rectangle>();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        SummedSqTiltAreaTable sat = new SummedSqTiltAreaTable(image, this.cascade.hasTiltedFeatures);
        int nFactors = 0;
        int startFactor = 0;
        float factor = 1.0f;
        while (factor * (float)this.cascade.width < (float)(imageWidth - 10) && factor * (float)this.cascade.height < (float)(imageHeight - 10)) {
            float width = factor * (float)this.cascade.width;
            float height = factor * (float)this.cascade.height;
            if (width < (float)this.minSize || height < (float)this.minSize) {
                ++startFactor;
            }
            if (this.maxSize > 0 && (width > (float)this.maxSize || height > (float)this.maxSize)) break;
            ++nFactors;
            factor *= this.scaleFactor;
        }
        factor = (float)Math.pow(this.scaleFactor, startFactor);
        for (int scaleStep = startFactor; scaleStep < nFactors; ++scaleStep) {
            float ystep = Math.max(2.0f, factor);
            int windowWidth = (int)(factor * (float)this.cascade.width);
            int windowHeight = (int)(factor * (float)this.cascade.height);
            int startX = (int)(this.roi == null ? 0.0f : Math.max(0.0f, this.roi.x));
            int startY = (int)(this.roi == null ? 0.0f : Math.max(0.0f, this.roi.y));
            int stopX = Math.round(((this.roi == null ? (float)imageWidth : Math.min((float)imageWidth, this.roi.x + this.roi.width)) - (float)windowWidth) / ystep);
            int stopY = Math.round(((this.roi == null ? (float)imageHeight : Math.min((float)imageHeight, this.roi.y + this.roi.height)) - (float)windowHeight) / ystep);
            this.cascade.setScale(factor);
            this.detectAtScale(sat, startX, stopX, startY, stopY, ystep, windowWidth, windowHeight, results);
            factor *= this.scaleFactor;
        }
        return results;
    }

    public int smallStep() {
        return this.smallStep;
    }

    public int bigStep() {
        return this.bigStep;
    }

    public void setSmallStep(int smallStep) {
        this.smallStep = smallStep;
    }

    public void bigStep(int bigStep) {
        this.bigStep = bigStep;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(float scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public StageTreeClassifier getClassifier() {
        return this.cascade;
    }
}

