/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection.datasets;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.vfs2.FileSystemException;
import org.openimaj.data.DataUtils;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.data.dataset.VFSListDataset;
import org.openimaj.experiment.annotations.DatasetDescription;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.math.geometry.shape.Rectangle;

@DatasetDescription(name="INRIAPerson", description="Images of upright people in images and video. The dataset is divided in two formats: (a) original images with corresponding annotation files, and (b) positive images in normalized 64x128 pixel format (as used in the CVPR paper) with original negative images", creator="Navneet Dalal", url="http://pascal.inrialpes.fr/data/human/", downloadUrls={"http://datasets.openimaj.org/INRIAPerson.zip"})
public class INRIAPersonDataset {
    public static <IMAGE extends Image<?, IMAGE>> ListDataset<IMAGE> getNegativeTrainingImages(InputStreamObjectReader<IMAGE> reader) throws FileSystemException {
        VFSListDataset images = new VFSListDataset(DataUtils.getDataLocation((String)"INRIAPerson/train_64x128_H96/neg").toString(), reader);
        return images;
    }

    public static <IMAGE extends Image<?, IMAGE>> ListDataset<IMAGE> getPositiveTrainingImages(InputStreamObjectReader<IMAGE> reader) throws FileSystemException {
        VFSListDataset images = new VFSListDataset(DataUtils.getDataLocation((String)"INRIAPerson/train_64x128_H96/pos").toString(), reader);
        return images;
    }

    public static <IMAGE extends Image<?, IMAGE>> ListDataset<IMAGE> generateNegativeExamples(int numSamplesPerImage, int width, int height, long seed, InputStreamObjectReader<IMAGE> reader) throws FileSystemException {
        Random rng = new Random(seed);
        final ListDataset<IMAGE> images = INRIAPersonDataset.getNegativeTrainingImages(reader);
        final ArrayList<NegEx> data = new ArrayList<NegEx>();
        for (int i = 0; i < images.size(); ++i) {
            Image image = (Image)images.getInstance(i);
            int imWidth = image.getWidth();
            int imHeight = image.getHeight();
            for (int j = 0; j < numSamplesPerImage; ++j) {
                NegEx ex = new NegEx();
                ex.id = i;
                ex.r = INRIAPersonDataset.generateRandomRect(rng, imWidth, imHeight, width, height);
                data.add(ex);
            }
        }
        return new ListBackedDataset((List)new AbstractList<IMAGE>(){
            int lastId = -1;
            IMAGE lastImage;

            @Override
            public IMAGE get(int index) {
                NegEx ex = (NegEx)data.get(index);
                if (ex.id != this.lastId) {
                    this.lastImage = (Image)images.get(ex.id);
                    this.lastId = ex.id;
                }
                Object image = this.lastImage;
                return image.extractROI(ex.r);
            }

            @Override
            public int size() {
                return data.size();
            }
        });
    }

    private static Rectangle generateRandomRect(Random rng, int imWidth, int imHeight, int width, int height) {
        int maxx = imWidth - width;
        int maxy = imHeight - height;
        int x = rng.nextInt(maxx);
        int y = rng.nextInt(maxy);
        return new Rectangle((float)x, (float)y, (float)width, (float)height);
    }

    public static GroupedDataset<Boolean, ListDataset<FImage>, FImage> getTrainingData() throws FileSystemException {
        MapBackedDataset ds = new MapBackedDataset();
        ds.put((Object)true, INRIAPersonDataset.getPositiveTrainingImages(ImageUtilities.FIMAGE_READER));
        ds.put((Object)false, INRIAPersonDataset.generateNegativeExamples(10, 64, 128, 0L, ImageUtilities.FIMAGE_READER));
        return ds;
    }

    static class NegEx {
        int id;
        Rectangle r;

        NegEx() {
        }
    }
}

