/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.loss;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;

public abstract class LossFunction {
    protected Matrix X;
    protected Matrix Y;
    protected Matrix bias;

    public void setX(Matrix X) {
        this.X = X;
    }

    public void setY(Matrix Y) {
        this.Y = Y;
    }

    public abstract Matrix gradient(Matrix var1);

    public abstract double eval(Matrix var1);

    public void setBias(Matrix bias) {
        this.bias = bias;
    }

    public abstract boolean isMatrixLoss();

    public boolean test_backtrack(Matrix W, Matrix grad, Matrix prox, double eta) {
        Matrix tmp = prox.clone();
        tmp.minusEquals((Ring)W);
        Vector tmpvec = tmp.getColumn(0);
        return this.eval(prox) <= this.eval(W) + grad.getColumn(0).dotProduct(tmpvec) + 0.5 * eta * tmpvec.norm2();
    }
}

