/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.BatchAnnotator;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.util.pair.IndependentPair;

public class ModelAnnotator<OBJECT, ANNOTATION, FEATURE>
extends BatchAnnotator<OBJECT, ANNOTATION> {
    EstimatableModel<FEATURE, ANNOTATION> model;
    Set<ANNOTATION> annotations;
    private FeatureExtractor<FEATURE, OBJECT> extractor;

    public ModelAnnotator(FeatureExtractor<FEATURE, OBJECT> extractor, EstimatableModel<FEATURE, ANNOTATION> model, Set<ANNOTATION> annotations) {
        this.extractor = extractor;
        this.model = model;
        this.annotations = annotations;
    }

    @Override
    public void train(List<? extends Annotated<OBJECT, ANNOTATION>> data) {
        ArrayList<IndependentPair> featureData = new ArrayList<IndependentPair>();
        for (Annotated<OBJECT, ANNOTATION> a : data) {
            Object f = this.extractor.extractFeature(a.getObject());
            for (ANNOTATION ann : a.getAnnotations()) {
                featureData.add(IndependentPair.pair((Object)f, ann));
            }
        }
        this.model.estimate(featureData);
    }

    @Override
    public Set<ANNOTATION> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<ScoredAnnotation<ANNOTATION>> annotate(OBJECT object) {
        Object f = this.extractor.extractFeature(object);
        ArrayList<ScoredAnnotation<ANNOTATION>> result = new ArrayList<ScoredAnnotation<ANNOTATION>>();
        result.add(new ScoredAnnotation<Object>(this.model.predict(f), 1.0f));
        return result;
    }
}

