/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix;

import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import org.openimaj.util.function.Operation;
import org.openimaj.util.parallel.Parallel;

public class ThreadedMatrixMulti {
    private double[][] answer;
    private double[][] a;
    private double[][] b;
    private int answerCols;
    private int answerRows;

    public ThreadedMatrixMulti() {
    }

    public ThreadedMatrixMulti(int numRows, int numCols) {
        this.newAnswer(numRows, numCols);
    }

    public Matrix times(Matrix a, Matrix b) {
        double[][] ad = ThreadedMatrixMulti.fromMatrix(a);
        double[][] bd = ThreadedMatrixMulti.fromMatrix(b);
        return this.times(ad, bd);
    }

    public Matrix times(double[][] a, double[][] b) {
        this.a = a;
        this.b = b;
        this.answerCols = b[0].length;
        this.answerRows = a.length;
        if (this.answer != null) {
            if (this.answer[0].length != this.answerCols || this.answer.length != this.answerRows) {
                this.answer = this.newAnswer(this.answerRows, this.answerCols);
            }
        } else {
            this.answer = this.newAnswer(this.answerRows, this.answerCols);
        }
        Parallel.forIndex((int)0, (int)(this.answerRows * this.answerCols), (int)1, (Operation)new MultiplicationOperation());
        return DenseMatrixFactoryMTJ.INSTANCE.copyArray(this.answer);
    }

    private static double[][] fromMatrix(Matrix a) {
        double[][] ret = new double[a.getNumRows()][a.getNumColumns()];
        for (MatrixEntry ds : a) {
            ret[ds.getRowIndex()][ds.getColumnIndex()] = ds.getValue();
        }
        return ret;
    }

    public void setAnswerElement(int rowi, int coli, double ans) {
        this.answer[rowi][coli] = ans;
    }

    private double[][] newAnswer(int answerRows, int answerCols) {
        return new double[answerRows][answerCols];
    }

    class MultiplicationOperation
    implements Operation<Integer> {
        MultiplicationOperation() {
        }

        public void perform(Integer object) {
            int rowi = object / ThreadedMatrixMulti.this.answerCols;
            int coli = object - rowi * ThreadedMatrixMulti.this.answerCols;
            double dot = 0.0;
            for (int i = 0; i < ThreadedMatrixMulti.this.a[rowi].length; ++i) {
                dot += ThreadedMatrixMulti.this.a[rowi][i] * ThreadedMatrixMulti.this.b[i][coli];
            }
            ThreadedMatrixMulti.this.setAnswerElement(rowi, coli, dot);
        }
    }
}

