/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.tracking.klt;

import org.openimaj.image.FImage;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.video.tracking.klt.Pyramid;
import org.openimaj.video.tracking.klt.PyramidSet;

public class TrackingContext {
    protected static final int _mindist = 10;
    protected static final int _window_size = 7;
    protected static final int _min_eigenvalue = 1;
    protected static final float _min_determinant = 0.01f;
    protected static final float _min_displacement = 0.1f;
    protected static final int _max_iterations = 10;
    protected static final float _max_residue = 10.0f;
    protected static final float _grad_sigma = 1.0f;
    protected static final float _smooth_sigma_fact = 0.1f;
    protected static final float _pyramid_sigma_fact = 0.9f;
    protected static final float _step_factor = 1.0f;
    protected static boolean _sequentialMode = false;
    protected static final boolean _lighting_insensitive = false;
    protected static final int _affineConsistencyCheck = -1;
    protected static final int _affine_window_size = 15;
    protected static final int _affine_max_iterations = 10;
    protected static final float _affine_max_residue = 10.0f;
    protected static final float _affine_min_displacement = 0.02f;
    protected static final float _affine_max_displacement_differ = 1.5f;
    protected static final boolean _smoothBeforeSelecting = true;
    protected static final boolean _writeInternalImages = false;
    protected static final int _search_range = 15;
    protected static final int _nSkippedPixels = 0;
    int mindist = 10;
    int window_width = 7;
    int window_height = 7;
    boolean sequentialMode;
    boolean smoothBeforeSelecting = true;
    boolean writeInternalImages = false;
    boolean lighting_insensitive = false;
    int min_eigenvalue = 1;
    float min_determinant = 0.01f;
    float min_displacement = 0.1f;
    int max_iterations = 10;
    float max_residue = 10.0f;
    float grad_sigma = 1.0f;
    float smooth_sigma_fact = 0.1f;
    float pyramid_sigma_fact = 0.9f;
    float step_factor = 1.0f;
    int nSkippedPixels = 0;
    int borderx;
    int bordery;
    int nPyramidLevels;
    int subsampling;
    int affine_window_width = 15;
    int affine_window_height = 15;
    int affineConsistencyCheck = -1;
    int affine_max_iterations = 10;
    float affine_max_residue = 10.0f;
    float affine_min_displacement = 0.02f;
    float affine_max_displacement_differ = 1.5f;
    private Shape targetArea = null;
    private Pyramid pyramid_last = null;
    private Pyramid pyramid_last_gradx = null;
    private Pyramid pyramid_last_grady = null;
    ConvolutionKernel gauss_kernel = new ConvolutionKernel();
    ConvolutionKernel gaussderiv_kernel = new ConvolutionKernel();
    float sigma_last = -10.0f;

    public PyramidSet previousPyramidSet() {
        if (this.pyramid_last == null) {
            return null;
        }
        return new PyramidSet(this.pyramid_last, this.pyramid_last_gradx, this.pyramid_last_grady);
    }

    public TrackingContext() {
        this.sequentialMode = _sequentialMode;
        this.changeTCPyramid(15);
        this.updateTCBorder();
    }

    public String toString() {
        String s = "";
        s = s + String.format("\n\nTracking context:\n\n", new Object[0]);
        s = s + String.format("\tmindist = %d\n", this.mindist);
        s = s + String.format("\twindow_width = %d\n", this.window_width);
        s = s + String.format("\twindow_height = %d\n", this.window_height);
        s = s + String.format("\tsequentialMode = %s\n", this.sequentialMode ? "true" : "false");
        s = s + String.format("\tsmoothBeforeSelecting = %s\n", this.smoothBeforeSelecting ? "true" : "false");
        s = s + String.format("\twriteInternalImages = %s\n", this.writeInternalImages ? "true" : "false");
        s = s + String.format("\tmin_eigenvalue = %d\n", this.min_eigenvalue);
        s = s + String.format("\tmin_determinant = %f\n", Float.valueOf(this.min_determinant));
        s = s + String.format("\tmin_displacement = %f\n", Float.valueOf(this.min_displacement));
        s = s + String.format("\tmax_iterations = %d\n", this.max_iterations);
        s = s + String.format("\tmax_residue = %f\n", Float.valueOf(this.max_residue));
        s = s + String.format("\tgrad_sigma = %f\n", Float.valueOf(this.grad_sigma));
        s = s + String.format("\tsmooth_sigma_fact = %f\n", Float.valueOf(this.smooth_sigma_fact));
        s = s + String.format("\tpyramid_sigma_fact = %f\n", Float.valueOf(this.pyramid_sigma_fact));
        s = s + String.format("\tnSkippedPixels = %d\n", this.nSkippedPixels);
        s = s + String.format("\tborderx = %d\n", this.borderx);
        s = s + String.format("\tbordery = %d\n", this.bordery);
        s = s + String.format("\tnPyramidLevels = %d\n", this.nPyramidLevels);
        s = s + String.format("\tsubsampling = %d\n", this.subsampling);
        s = s + String.format("\n\tpyramid_last = %s\n", this.pyramid_last != null ? "points to old image" : "null");
        s = s + String.format("\tpyramid_last_gradx = %s\n", this.pyramid_last_gradx != null ? "points to old image" : "null");
        s = s + String.format("\tpyramid_last_grady = %s\n", this.pyramid_last_grady != null ? "points to old image" : "null");
        s = s + String.format("\n\n", new Object[0]);
        return s;
    }

    public void changeTCPyramid(int search_range) {
        float window_halfwidth;
        float subsampling;
        if (this.window_width % 2 != 1) {
            ++this.window_width;
            System.err.format("(KLTChangeTCPyramid) Window width must be odd. Changing to %d.\n", this.window_width);
        }
        if (this.window_height % 2 != 1) {
            ++this.window_height;
            System.err.format("(KLTChangeTCPyramid) Window height must be odd. Changing to %d.\n", this.window_height);
        }
        if (this.window_width < 3) {
            this.window_width = 3;
            System.err.format("(KLTChangeTCPyramid) Window width must be at least three. \nChanging to %d.\n", this.window_width);
        }
        if (this.window_height < 3) {
            this.window_height = 3;
            System.err.format("(KLTChangeTCPyramid) Window height must be at least three. \nChanging to %d.\n", this.window_height);
        }
        if ((double)(subsampling = (float)search_range / (window_halfwidth = (float)Math.min(this.window_width, this.window_height) / 2.0f)) < 1.0) {
            this.nPyramidLevels = 1;
        } else if ((double)subsampling <= 3.0) {
            this.nPyramidLevels = 2;
            this.subsampling = 2;
        } else if ((double)subsampling <= 5.0) {
            this.nPyramidLevels = 2;
            this.subsampling = 4;
        } else if ((double)subsampling <= 9.0) {
            this.nPyramidLevels = 2;
            this.subsampling = 8;
        } else {
            float val = (float)(Math.log(7.0 * (double)subsampling + 1.0) / Math.log(8.0));
            this.nPyramidLevels = (int)((double)val + 0.99);
            this.subsampling = 8;
        }
    }

    float _pyramidSigma() {
        return this.pyramid_sigma_fact * (float)this.subsampling;
    }

    public void updateTCBorder() {
        int border;
        int i;
        int num_levels = this.nPyramidLevels;
        int ss = this.subsampling;
        if (this.window_width % 2 != 1) {
            ++this.window_width;
            System.err.format("(KLTUpdateTCBorder) Window width must be odd. Changing to %d.\n", this.window_width);
        }
        if (this.window_height % 2 != 1) {
            ++this.window_height;
            System.err.format("(KLTUpdateTCBorder) Window height must be odd. Changing to %d.\n", this.window_height);
        }
        if (this.window_width < 3) {
            this.window_width = 3;
            System.err.format("(KLTUpdateTCBorder) Window width must be at least three. \nChanging to %d.\n", this.window_width);
        }
        if (this.window_height < 3) {
            this.window_height = 3;
            System.err.format("(KLTUpdateTCBorder) Window height must be at least three. \nChanging to %d.\n", this.window_height);
        }
        int window_hw = Math.max(this.window_width, this.window_height) / 2;
        int gauss_width = this._getKernelWidths(this.computeSmoothSigma())[0];
        int smooth_gauss_hw = gauss_width / 2;
        gauss_width = this._getKernelWidths(this._pyramidSigma())[0];
        int pyramid_gauss_hw = gauss_width / 2;
        int n_invalid_pixels = smooth_gauss_hw;
        for (i = 1; i < num_levels; ++i) {
            float val = ((float)n_invalid_pixels + (float)pyramid_gauss_hw) / (float)ss;
            n_invalid_pixels = (int)((double)val + 0.99);
        }
        int ss_power = 1;
        for (i = 1; i < num_levels; ++i) {
            ss_power *= ss;
        }
        this.borderx = border = (n_invalid_pixels + window_hw) * ss_power;
        this.bordery = border;
    }

    void stopSequentialMode() {
        this.sequentialMode = false;
        this.pyramid_last = null;
        this.pyramid_last_gradx = null;
        this.pyramid_last_grady = null;
    }

    float computeSmoothSigma() {
        return this.smooth_sigma_fact * (float)Math.max(this.window_width, this.window_height);
    }

    void _computeKernels(float sigma, ConvolutionKernel gauss, ConvolutionKernel gaussderiv) {
        int i;
        float factor = 0.01f;
        int hw = 35;
        float max_gauss = 1.0f;
        float max_gaussderiv = (float)((double)sigma * Math.exp(-0.5));
        for (i = -35; i <= 35; ++i) {
            gauss.data[i + 35] = (float)Math.exp((float)(-i * i) / (2.0f * sigma * sigma));
            gaussderiv.data[i + 35] = (float)(-i) * gauss.data[i + 35];
        }
        gauss.width = 71;
        i = -35;
        while (Math.abs(gauss.data[i + 35] / max_gauss) < 0.01f) {
            gauss.width -= 2;
            ++i;
        }
        gaussderiv.width = 71;
        i = -35;
        while (Math.abs(gaussderiv.data[i + 35] / max_gaussderiv) < 0.01f) {
            gaussderiv.width -= 2;
            ++i;
        }
        if (gauss.width == 71 || gaussderiv.width == 71) {
            throw new RuntimeException(String.format("(_computeKernels) MAX_KERNEL_WIDTH %d is too small for a sigma of %f", 71, Float.valueOf(sigma)));
        }
        for (i = 0; i < gauss.width; ++i) {
            gauss.data[i] = gauss.data[i + (71 - gauss.width) / 2];
        }
        for (i = 0; i < gaussderiv.width; ++i) {
            gaussderiv.data[i] = gaussderiv.data[i + (71 - gaussderiv.width) / 2];
        }
        hw = gaussderiv.width / 2;
        float den = 0.0f;
        for (i = 0; i < gauss.width; ++i) {
            den += gauss.data[i];
        }
        i = 0;
        while (i < gauss.width) {
            int n = i++;
            gauss.data[n] = gauss.data[n] / den;
        }
        den = 0.0f;
        for (i = -hw; i <= hw; ++i) {
            den -= (float)i * gaussderiv.data[i + hw];
        }
        for (i = -hw; i <= hw; ++i) {
            int n = i + hw;
            gaussderiv.data[n] = gaussderiv.data[n] / den;
        }
        this.sigma_last = sigma;
    }

    int[] _getKernelWidths(float sigma) {
        this._computeKernels(sigma, this.gauss_kernel, this.gaussderiv_kernel);
        int gauss_width = this.gauss_kernel.width;
        int gaussderiv_width = this.gaussderiv_kernel.width;
        return new int[]{gauss_width, gaussderiv_width};
    }

    void _convolveImageHoriz(FImage imgin, ConvolutionKernel kernel, FImage imgout) {
        int radius = kernel.width / 2;
        int ncols = imgin.width;
        int nrows = imgin.height;
        assert (kernel.width % 2 == 1);
        assert (imgin != imgout);
        for (int j = 0; j < nrows; ++j) {
            int i;
            int ptrout = 0;
            for (i = 0; i < radius; ++i) {
                imgout.pixels[j][ptrout++] = 0.0f;
            }
            while (i < ncols - radius) {
                int ppp = i - radius;
                float sum = 0.0f;
                for (int k = kernel.width - 1; k >= 0; --k) {
                    sum += imgin.pixels[j][ppp++] * kernel.data[k];
                }
                imgout.pixels[j][ptrout++] = sum;
                ++i;
            }
            while (i < ncols) {
                imgout.pixels[j][ptrout++] = 0.0f;
                ++i;
            }
        }
    }

    void _convolveImageVert(FImage imgin, ConvolutionKernel kernel, FImage imgout) {
        int radius = kernel.width / 2;
        int ncols = imgin.width;
        int nrows = imgin.height;
        assert (kernel.width % 2 == 1);
        assert (imgin != imgout);
        for (int i = 0; i < ncols; ++i) {
            int j;
            int ptrout = 0;
            for (j = 0; j < radius; ++j) {
                imgout.pixels[ptrout][i] = 0.0f;
                ++ptrout;
            }
            while (j < nrows - radius) {
                int ppp = j - radius;
                float sum = 0.0f;
                for (int k = kernel.width - 1; k >= 0; --k) {
                    sum += imgin.pixels[ppp][i] * kernel.data[k];
                    ++ppp;
                }
                imgout.pixels[ptrout][i] = sum;
                ++ptrout;
                ++j;
            }
            while (j < nrows) {
                imgout.pixels[ptrout][i] = 0.0f;
                ++ptrout;
                ++j;
            }
        }
    }

    void _convolveSeparate(FImage imgin, ConvolutionKernel horiz_kernel, ConvolutionKernel vert_kernel, FImage imgout) {
        FImage tmpimg = new FImage(imgin.width, imgin.height);
        this._convolveImageHoriz(imgin, horiz_kernel, tmpimg);
        this._convolveImageVert(tmpimg, vert_kernel, imgout);
    }

    public void computeGradients(FImage img, float sigma, FImage gradx, FImage grady) {
        if ((double)Math.abs(sigma - this.sigma_last) > 0.05) {
            this._computeKernels(sigma, this.gauss_kernel, this.gaussderiv_kernel);
        }
        this._convolveSeparate(img, this.gaussderiv_kernel, this.gauss_kernel, gradx);
        this._convolveSeparate(img, this.gauss_kernel, this.gaussderiv_kernel, grady);
    }

    public int getMinDist() {
        return this.mindist;
    }

    public void setMinDist(int mindist) {
        this.mindist = mindist;
    }

    public int getWindowWidth() {
        return this.window_width;
    }

    public void setWindowWidth(int window_width) {
        this.window_width = window_width;
    }

    public int getWindowHeight() {
        return this.window_height;
    }

    public void setWindowHeight(int window_height) {
        this.window_height = window_height;
    }

    public boolean sequentialMode() {
        return this.sequentialMode;
    }

    public void setSequentialMode(boolean sequentialMode) {
        this.sequentialMode = sequentialMode;
    }

    public boolean writeInternalImages() {
        return this.writeInternalImages;
    }

    public void setWriteInternalImages(boolean writeInternalImages) {
        this.writeInternalImages = writeInternalImages;
    }

    public boolean isLightingInsensitive() {
        return this.lighting_insensitive;
    }

    public void setLightingInsensitive(boolean lighting_insensitive) {
        this.lighting_insensitive = lighting_insensitive;
    }

    public int getMinEigenvalue() {
        return this.min_eigenvalue;
    }

    public void setMinEigenvalue(int min_eigenvalue) {
        this.min_eigenvalue = min_eigenvalue;
    }

    public float getMinDeterminant() {
        return this.min_determinant;
    }

    public void setMinDeterminant(float min_determinant) {
        this.min_determinant = min_determinant;
    }

    public float getMinDisplacement() {
        return this.min_displacement;
    }

    public void setMinDisplacement(float min_displacement) {
        this.min_displacement = min_displacement;
    }

    public int getMaxIterations() {
        return this.max_iterations;
    }

    public void setMaxIterations(int max_iterations) {
        this.max_iterations = max_iterations;
    }

    public float getMaxResidue() {
        return this.max_residue;
    }

    public void setMaxResidue(float max_residue) {
        this.max_residue = max_residue;
    }

    public float getStepFactor() {
        return this.step_factor;
    }

    public void setStepFactor(float step_factor) {
        this.step_factor = step_factor;
    }

    public int getSubsampling() {
        return this.subsampling;
    }

    public void setSubsampling(int subsampling) {
        this.subsampling = subsampling;
    }

    public int getAffineConsistencyCheck() {
        return this.affineConsistencyCheck;
    }

    public void setAffineConsistencyCheck(int affineConsistencyCheck) {
        this.affineConsistencyCheck = affineConsistencyCheck;
    }

    public void setTargetArea(Shape targetArea) {
        this.targetArea = targetArea;
    }

    public Shape getTargetArea() {
        return this.targetArea;
    }

    public void setPreviousPyramid(PyramidSet pyr) {
        this.pyramid_last = pyr.imgPyr;
        this.pyramid_last_gradx = pyr.gradx;
        this.pyramid_last_grady = pyr.grady;
    }

    public PyramidSet getPreviousPyramid() {
        PyramidSet ret = new PyramidSet();
        ret.imgPyr = this.pyramid_last;
        ret.gradx = this.pyramid_last_gradx;
        ret.grady = this.pyramid_last_grady;
        return ret;
    }

    private class ConvolutionKernel {
        private static final int MAX_KERNEL_WIDTH = 71;
        int width;
        float[] data = new float[71];

        private ConvolutionKernel() {
        }
    }
}

