/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.tracking.klt;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.video.tracking.klt.Pyramid;
import org.openimaj.video.tracking.klt.TrackingContext;

public class PyramidSet {
    public Pyramid imgPyr;
    public Pyramid gradx;
    public Pyramid grady;

    public PyramidSet(FImage image, TrackingContext tc) {
        int nrows = image.height;
        int ncols = image.width;
        FImage floatimg2 = (FImage)image.process((SinglebandImageProcessor)new FGaussianConvolve(tc.computeSmoothSigma()));
        this.imgPyr = new Pyramid(ncols, nrows, tc.subsampling, tc.nPyramidLevels);
        this.imgPyr.computePyramid(floatimg2, tc.pyramid_sigma_fact);
        this.gradx = new Pyramid(ncols, nrows, tc.subsampling, tc.nPyramidLevels);
        this.grady = new Pyramid(ncols, nrows, tc.subsampling, tc.nPyramidLevels);
        for (int i = 0; i < tc.nPyramidLevels; ++i) {
            tc.computeGradients(this.imgPyr.img[i], tc.grad_sigma, this.gradx.img[i], this.grady.img[i]);
        }
    }

    public PyramidSet(Pyramid imgPyr, Pyramid gradx, Pyramid grady) {
        this.imgPyr = imgPyr;
        this.gradx = gradx;
        this.grady = grady;
    }

    PyramidSet() {
    }

    public boolean isNull() {
        return this.imgPyr == null || this.grady == null || this.gradx == null;
    }
}

