/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.tracking.klt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openimaj.video.tracking.klt.Feature;
import org.openimaj.video.tracking.klt.FeatureList;

public class FeatureHistory {
    Map<Integer, List<List<Feature>>> history = new TreeMap<Integer, List<List<Feature>>>();
    public List<Feature>[] currentState;

    public FeatureHistory(int nFeatures) {
        this.currentState = new List[nFeatures];
    }

    public void record(FeatureList fl, int frame) {
        for (int i = 0; i < fl.features.length; ++i) {
            Feature f = fl.features[i];
            if (f.val >= 0) {
                if (this.currentState[i] == null) {
                    List<Object> hist;
                    ArrayList<Feature> ff = new ArrayList<Feature>();
                    if (this.history.containsKey(frame)) {
                        hist = this.history.get(frame);
                    } else {
                        hist = new ArrayList();
                        this.history.put(frame, hist);
                    }
                    hist.add(ff);
                    this.currentState[i] = ff;
                }
                if (this.currentState[i].size() != 0 && this.currentState[i].get(this.currentState[i].size() - 1).equals(f)) continue;
                this.currentState[i].add(f.clone());
                continue;
            }
            this.currentState[i] = null;
        }
    }

    public String toString() {
        String s = "FeatureHistory[\n";
        for (int startframe : this.history.keySet()) {
            List<List<Feature>> tracks = this.history.get(startframe);
            s = s + "Starting frame: " + startframe + ":\n";
            for (int i = 0; i < tracks.size(); ++i) {
                s = s + "\t" + i + " " + tracks.get(i) + "\n";
            }
        }
        return s + "]";
    }
}

